/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class HttpsAccessIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;
    private String httpsUri;

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Before
    public void startServer() throws NoSuchAlgorithmException, KeyManagementException, IOException {
        this.server = CommunityServerBuilder.server().withHttpsEnabled().usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.httpsUri = this.server.httpsUri().toASCIIString();
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    @Test
    public void serverShouldSupportSsl() throws Exception {
        this.server.start();
        Assert.assertThat((Object)this.server.getHttpsEnabled(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)HTTP.GET(this.httpsUri).status(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void webadminShouldBeRetrievableViaSsl() throws Exception {
        this.server.start();
        Assert.assertThat((Object)HTTP.GET(this.httpsUri + "webadmin/").status(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void txEndpointShouldReplyWithHttpsWhenItReturnsURLs() throws Exception {
        this.server.start();
        HTTP.Response response = HTTP.POST(this.httpsUri + "db/data/transaction", HTTP.RawPayload.quotedJson("{'statements':[]}"));
        Assert.assertThat((Object)response.location(), (Matcher)CoreMatchers.startsWith((String)this.httpsUri));
        Assert.assertThat((Object)response.get("commit").asText(), (Matcher)CoreMatchers.startsWith((String)this.httpsUri));
    }
}

