/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class NeoServerPortConflictDocIT
extends ExclusiveServerTestBase {
    @Test
    public void shouldComplainIfServerPortIsAlreadyTaken() throws IOException {
        int contestedPort = 9999;
        try (ServerSocket ignored = new ServerSocket(contestedPort, 0, InetAddress.getByName("0.0.0.0"));){
            AssertableLogProvider logProvider = new AssertableLogProvider();
            CommunityNeoServer server = CommunityServerBuilder.server((LogProvider)logProvider).onPort(contestedPort).usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).onHost("0.0.0.0").build();
            try {
                server.start();
                Assert.fail((String)"Should have reported failure to start");
            }
            catch (ServerStartupException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Starting Neo4j failed"));
            }
            logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog((Matcher)Matchers.containsString((String)"CommunityNeoServer")).error("Failed to start Neo Server on port %d: %s", new Object[]{9999, Matchers.startsWith((String)"Address 0.0.0.0:9999 is already in use, cannot bind to it.")})});
            server.stop();
        }
    }
}

