/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.lang.SystemUtils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.test.TargetDirectory;

public class HTTPLoggingPreparednessRuleTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void shouldPassWhenExplicitlyDisabled() {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{ServerSettings.http_logging_enabled.name(), "false"}));
        config.get(ServerSettings.http_log_config_file);
    }

    @Test
    public void shouldPassWhenImplicitlyDisabled() {
        Config config = Config.empty();
        config.get(ServerSettings.http_log_config_file);
    }

    @Test
    public void shouldPassWhenEnabledWithGoodConfigSpecified() throws Exception {
        File logDir = this.testDirectory.directory("logDir");
        File confDir = this.testDirectory.directory("confDir");
        Config config = new Config(MapUtil.stringMap((String[])new String[]{ServerSettings.http_logging_enabled.name(), "true", ServerSettings.http_log_config_file.name(), HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDir), confDir).getAbsolutePath()}));
        config.get(ServerSettings.http_log_config_file);
    }

    @Test
    public void shouldFailWhenEnabledWithUnwritableLogDirSpecifiedInConfig() throws Exception {
        File confDir = this.testDirectory.directory("confDir");
        File unwritableDirectory = HTTPLoggingPreparednessRuleTest.createUnwritableDirectory();
        Config config = new Config(MapUtil.stringMap((String[])new String[]{ServerSettings.http_logging_enabled.name(), "true", ServerSettings.http_log_config_file.name(), HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(unwritableDirectory), confDir).getAbsolutePath()}));
        this.exception.expect(InvalidSettingException.class);
        config.get(ServerSettings.http_log_config_file);
    }

    public static File createUnwritableDirectory() {
        File file = SystemUtils.IS_OS_WINDOWS ? new File("\\\\" + UUID.randomUUID().toString() + "\\") : (SystemUtils.IS_OS_MAC_OSX ? new File("/Network/Servers/localhost/" + UUID.randomUUID().toString()) : new File("/proc/" + UUID.randomUUID().toString() + "/random"));
        return file;
    }

    public static File createConfigFile(String configXml, File location) throws IOException {
        File configFile = new File(location.getAbsolutePath() + File.separator + "neo4j-logback-config.xml");
        FileOutputStream fos = new FileOutputStream(configFile);
        fos.write(configXml.getBytes());
        fos.close();
        return configFile;
    }

    public static String createLogbackConfigXml(File logDirectory) {
        return HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDirectory, "%h %l %user [%t{dd/MMM/yyyy:HH:mm:ss Z}] \"%r\" %s %b \"%i{Referer}\" \"%i{User-Agent}\"");
    }

    public static String createLogbackConfigXml(File logDirectory, String logPattern) {
        return "<configuration>\n  <appender name=\"FILE\" class=\"ch.qos.logback.core.rolling.RollingFileAppender\">\n    <file>" + logDirectory.getAbsolutePath() + File.separator + "http.log</file>\n" + "    <rollingPolicy class=\"ch.qos.logback.core.rolling.TimeBasedRollingPolicy\">\n" + "      <fileNamePattern>" + logDirectory.getAbsolutePath() + File.separator + "http.%d{yyyy-MM-dd_HH}.log</fileNamePattern>\n" + "      <maxHistory>30</maxHistory>\n" + "    </rollingPolicy>\n" + "\n" + "    <encoder>\n" + "      <!-- Note the deliberate misspelling of \"referer\" in accordance with RFC 2616 -->\n" + "      <pattern>" + logPattern + "</pattern>\n" + "    </encoder>\n" + "  </appender>\n" + "\n" + "  <appender-ref ref=\"FILE\" />\n" + "</configuration>";
    }
}

