/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.util.concurrent.CountDownLatch;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.test.SuppressOutput;

public class JettyThreadLimitTest {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHaveConfigurableJettyThreadPoolSize() throws Exception {
        Jetty9WebServer server = new Jetty9WebServer((LogProvider)NullLogProvider.getInstance(), Config.empty());
        int numCores = 1;
        int configuredMaxThreads = 12;
        int acceptorThreads = 1;
        int selectorThreads = 1;
        int jobThreads = configuredMaxThreads - acceptorThreads - selectorThreads;
        server.setMaxThreads(numCores);
        server.setPort(7480);
        try {
            server.start();
            QueuedThreadPool threadPool = (QueuedThreadPool)server.getJetty().getThreadPool();
            threadPool.start();
            CountDownLatch startLatch = new CountDownLatch(jobThreads);
            CountDownLatch endLatch = this.loadThreadPool(threadPool, configuredMaxThreads + 1, startLatch);
            startLatch.await();
            int threads = threadPool.getThreads();
            Assert.assertEquals((String)"Wrong number of threads in pool", (long)configuredMaxThreads, (long)threads);
            endLatch.countDown();
        }
        finally {
            server.stop();
        }
    }

    private CountDownLatch loadThreadPool(QueuedThreadPool threadPool, int tasksToSubmit, final CountDownLatch startLatch) {
        final CountDownLatch endLatch = new CountDownLatch(1);
        for (int i = 0; i < tasksToSubmit; ++i) {
            threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    startLatch.countDown();
                    try {
                        endLatch.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return endLatch;
    }
}

