/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.SuppressOutput;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class TestJetty9WebServer
extends ExclusiveServerTestBase {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    private Jetty9WebServer webServer;
    private CommunityNeoServer server;

    @Test
    public void shouldBeAbleToUsePortZero() throws Exception {
        this.webServer = new Jetty9WebServer((LogProvider)NullLogProvider.getInstance(), Config.empty());
        this.webServer.setPort(0);
        this.webServer.start();
    }

    @Test
    public void shouldBeAbleToRestart() throws Throwable {
        this.webServer = new Jetty9WebServer((LogProvider)NullLogProvider.getInstance(), Config.empty());
        this.webServer.setAddress("127.0.0.1");
        this.webServer.setPort(7878);
        this.webServer.start();
        this.webServer.stop();
        this.webServer.start();
    }

    @Test
    public void shouldStopCleanlyEvenWhenItHasntBeenStarted() {
        new Jetty9WebServer((LogProvider)NullLogProvider.getInstance(), null).stop();
    }

    @Test
    public void shouldDisallowDirectoryListings() throws Exception {
        this.server = CommunityServerBuilder.server().build();
        this.server.start();
        HTTP.Response okResource = HTTP.GET(this.server.baseUri().resolve("/webadmin/index.html").toString());
        HTTP.Response illegalResource = HTTP.GET(this.server.baseUri().resolve("/webadmin/css/").toString());
        Assert.assertEquals((long)200L, (long)okResource.status());
        Assert.assertEquals((long)403L, (long)illegalResource.status());
    }

    @After
    public void cleanup() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
        if (this.server != null) {
            this.server.stop();
        }
    }
}

