/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.BoltKernelExtension;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.shell.ShellSettings;

public class BaseServerConfigLoader {
    public Config loadConfig(File configFile, File legacyConfigFile, Log log, Pair<String, String> ... configOverrides) {
        if (log == null) {
            throw new IllegalArgumentException("log cannot be null ");
        }
        HashMap<String, String> settings = this.calculateSettings(configFile, legacyConfigFile, log, configOverrides);
        Config config = new Config(settings, this.settingsClasses(settings));
        config.setLogger(log);
        return config;
    }

    protected Iterable<Class<?>> settingsClasses(HashMap<String, String> settings) {
        return Arrays.asList(ServerSettings.class, GraphDatabaseSettings.class, DatabaseManagementSystemSettings.class);
    }

    private HashMap<String, String> calculateSettings(File configFile, File legacyConfigFile, Log log, Pair<String, String>[] configOverrides) {
        HashMap<String, String> settings = new HashMap<String, String>();
        if (configFile != null && configFile.exists()) {
            settings.putAll(BaseServerConfigLoader.loadFromFile(log, configFile));
        }
        settings.putAll(BaseServerConfigLoader.loadFromFile(log, legacyConfigFile));
        settings.putAll(this.toMap(configOverrides));
        BaseServerConfigLoader.overrideEmbeddedDefaults(settings);
        return settings;
    }

    private Map<String, String> toMap(Pair<String, String>[] configOverrides) {
        HashMap<String, String> overrides = new HashMap<String, String>();
        for (Pair<String, String> configOverride : configOverrides) {
            overrides.put((String)configOverride.first(), (String)configOverride.other());
        }
        return overrides;
    }

    private static void overrideEmbeddedDefaults(HashMap<String, String> config) {
        config.putIfAbsent(ShellSettings.remote_shell_enabled.name(), "true");
        config.putIfAbsent(GraphDatabaseSettings.logs_directory.name(), "logs");
        config.putIfAbsent(BoltKernelExtension.Settings.enabled.name(), "true");
        config.putIfAbsent(GraphDatabaseSettings.auth_enabled.name(), "true");
    }

    private static Map<String, String> loadFromFile(Log log, File file) {
        if (file == null) {
            return new HashMap<String, String>();
        }
        if (file.exists()) {
            try {
                return MapUtil.load((File)file);
            }
            catch (IOException e) {
                log.error("Unable to load config file [%s]: %s", new Object[]{file, e.getMessage()});
            }
        } else {
            log.warn("Config file [%s] does not exist.", new Object[]{file});
        }
        return new HashMap<String, String>();
    }
}

