/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.batch;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.server.rest.batch.BatchOperations;
import org.neo4j.server.rest.web.InternalJettyServletRequest;
import org.neo4j.server.rest.web.InternalJettyServletResponse;

public class BatchOperationsTest {
    private final BatchOperations ops = new BatchOperations(null){

        protected void invoke(String method, String path, String body, Integer id, URI targetUri, InternalJettyServletRequest req, InternalJettyServletResponse res) throws IOException, ServletException {
        }
    };

    @Test
    public void testReplaceLocations() throws Exception {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(100, "bar");
        Assert.assertEquals((Object)"foo", (Object)this.ops.replaceLocationPlaceholders("foo", map));
        Assert.assertEquals((Object)"foo bar", (Object)this.ops.replaceLocationPlaceholders("foo {100}", map));
        Assert.assertEquals((Object)"bar foo bar", (Object)this.ops.replaceLocationPlaceholders("{100} foo {100}", map));
        Assert.assertEquals((Object)"bar bar foo bar bar", (Object)this.ops.replaceLocationPlaceholders("bar {100} foo {100} bar", map));
    }

    @Test
    public void testSchemeInInternalJettyServletRequestForHttp() throws UnsupportedEncodingException {
        InternalJettyServletRequest req = new InternalJettyServletRequest("POST", "http://localhost:7473/db/data/node", "{'name':'node1'}", new InternalJettyServletResponse());
        Assert.assertEquals((Object)"http", (Object)req.getScheme());
    }

    @Test
    public void testSchemeInInternalJettyServletRequestForHttps() throws UnsupportedEncodingException {
        InternalJettyServletRequest req = new InternalJettyServletRequest("POST", "https://localhost:7473/db/data/node", "{'name':'node1'}", new InternalJettyServletResponse());
        Assert.assertEquals((Object)"https", (Object)req.getScheme());
    }

    @Test
    public void shouldForwardMetadataFromOuterRequest() throws Exception {
        HttpServletRequest mock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mock.getAuthType()).thenReturn((Object)"authorization/auth");
        Mockito.when((Object)mock.getRemoteAddr()).thenReturn((Object)"127.0.0.1");
        Mockito.when((Object)mock.getRemoteHost()).thenReturn((Object)"localhost");
        Mockito.when((Object)mock.getRemotePort()).thenReturn((Object)1);
        Mockito.when((Object)mock.getLocalAddr()).thenReturn((Object)"129.0.0.1");
        Mockito.when((Object)mock.getLocalPort()).thenReturn((Object)2);
        InternalJettyServletRequest req = new InternalJettyServletRequest("POST", "https://localhost:7473/db/data/node", "", new InternalJettyServletResponse(), mock);
        Assert.assertEquals((Object)"authorization/auth", (Object)req.getAuthType());
        Assert.assertEquals((Object)"127.0.0.1", (Object)req.getRemoteAddr());
        Assert.assertEquals((Object)"localhost", (Object)req.getRemoteHost());
        Assert.assertEquals((long)1L, (long)req.getRemotePort());
        Assert.assertEquals((long)2L, (long)req.getLocalPort());
        Assert.assertEquals((Object)"129.0.0.1", (Object)req.getLocalAddr());
    }

    @Test
    public void shouldIgnoreUnknownAndUnparseablePlaceholders() throws Throwable {
        Assert.assertEquals((Object)"foo {00000000010001010001001100111000100101010111001101110111}", (Object)this.ops.replaceLocationPlaceholders("foo {00000000010001010001001100111000100101010111001101110111}", Collections.emptyMap()));
        Assert.assertEquals((Object)"foo {2147483648}", (Object)this.ops.replaceLocationPlaceholders("foo {2147483648}", Collections.emptyMap()));
    }
}

