/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.server.BlockingBootstrapper;
import org.neo4j.server.Bootstrapper;
import org.neo4j.test.Assert;

public class BlockingBootstrapperTest {
    @Test
    public void shouldBlockUntilStoppedIfTheWrappedStartIsSuccessful() {
        AtomicInteger status = new AtomicInteger();
        AtomicBoolean exited = new AtomicBoolean(false);
        final AtomicBoolean running = new AtomicBoolean(false);
        BlockingBootstrapper bootstrapper = new BlockingBootstrapper(new Bootstrapper(){

            @SafeVarargs
            public final int start(Optional<File> configFile, Pair<String, String> ... configOverrides) {
                running.set(true);
                return 0;
            }

            public int stop() {
                running.set(false);
                return 0;
            }
        });
        new Thread(() -> {
            status.set(bootstrapper.start(null, new Pair[0]));
            exited.set(true);
        }).start();
        Assert.assertEventually((String)"Wrapped was not started", running::get, (Matcher)Matchers.is((Object)true), (long)10L, (TimeUnit)TimeUnit.SECONDS);
        MatcherAssert.assertThat((String)"Bootstrapper exited early", (Object)exited.get(), (Matcher)Matchers.is((Object)false));
        bootstrapper.stop();
        Assert.assertEventually((String)"Wrapped was not stopped", running::get, (Matcher)Matchers.is((Object)false), (long)10L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertEventually((String)"Bootstrapper did not exit", exited::get, (Matcher)Matchers.is((Object)true), (long)10L, (TimeUnit)TimeUnit.SECONDS);
        MatcherAssert.assertThat((String)"Bootstrapper did not propagate exit status", (Object)status.get(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void shouldNotBlockIfTheWrappedStartIsUnsuccessful() {
        AtomicInteger status = new AtomicInteger();
        AtomicBoolean exited = new AtomicBoolean(false);
        BlockingBootstrapper bootstrapper = new BlockingBootstrapper(new Bootstrapper(){

            @SafeVarargs
            public final int start(Optional<File> configFile, Pair<String, String> ... configOverrides) {
                return 1;
            }

            public int stop() {
                return 0;
            }
        });
        new Thread(() -> {
            status.set(bootstrapper.start(null, new Pair[0]));
            exited.set(true);
        }).start();
        Assert.assertEventually((String)"Blocked unexpectedly", exited::get, (Matcher)Matchers.is((Object)true), (long)10L, (TimeUnit)TimeUnit.SECONDS);
        MatcherAssert.assertThat((String)"Bootstrapper did not propagate exit status", (Object)status.get(), (Matcher)Matchers.is((Object)1));
    }
}

