/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Paths;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.server.rest.domain.RelationshipDirection;
import org.neo4j.server.rest.domain.RelationshipExpanderBuilder;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;

public class RelationshipExpanderBuilderTest {
    @ClassRule
    public static final DatabaseRule db = new ImpermanentDatabaseRule();

    @Test
    public void shouldInterpretNoSpecifiedRelationshipsAsAll() throws Exception {
        Set expanded;
        Node node = this.createSomeData();
        PathExpander expander = RelationshipExpanderBuilder.describeRelationships((Map)MapUtil.map((Object[])new Object[0]));
        try (Transaction tx = db.beginTx();){
            expanded = Iterables.asSet((Iterable)expander.expand(Paths.singleNodePath((Node)node), BranchState.NO_STATE));
            tx.success();
        }
        tx = db.beginTx();
        var5_4 = null;
        try {
            Assert.assertEquals((Object)Iterables.asSet((Iterable)node.getRelationships()), (Object)expanded);
            tx.success();
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldInterpretSomeSpecifiedRelationships() throws Exception {
        Set expanded;
        Node node = this.createSomeData();
        PathExpander expander = RelationshipExpanderBuilder.describeRelationships((Map)MapUtil.map((Object[])new Object[]{"relationships", MapUtil.map((Object[])new Object[]{"type", MyRelTypes.TEST.name(), "direction", RelationshipDirection.out.name()})}));
        try (Transaction tx = db.beginTx();){
            expanded = Iterables.asSet((Iterable)expander.expand(Paths.singleNodePath((Node)node), BranchState.NO_STATE));
            tx.success();
        }
        tx = db.beginTx();
        var5_4 = null;
        try {
            Assert.assertEquals((Object)Iterables.asSet((Iterable)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST})), (Object)expanded);
            tx.success();
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private Node createSomeData() {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            node.createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST2);
            tx.success();
            Node node2 = node;
            return node2;
        }
    }
}

