/*
 * Decompiled with CFR 0.152.
 */
package org.dummy.web.service;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;

@Path(value="/")
public class DummyThirdPartyWebService {
    public static final String DUMMY_WEB_SERVICE_MOUNT_POINT = "/dummy";

    @GET
    @Produces(value={"text/plain"})
    public Response sayHello() {
        return Response.ok().entity((Object)"hello").build();
    }

    @GET
    @Path(value="/{something}/{somethingElse}")
    @Produces(value={"text/plain"})
    public Response forSecurityTesting() {
        return Response.ok().entity((Object)"you've reached a dummy service").build();
    }

    @GET
    @Path(value="inject-test")
    @Produces(value={"text/plain"})
    public Response countNodes(@Context GraphDatabaseService db) {
        try (Transaction transaction = db.beginTx();){
            Response response = Response.ok().entity((Object)String.valueOf(this.countNodesIn(db))).build();
            return response;
        }
    }

    @GET
    @Path(value="needs-auth-header")
    @Produces(value={"application/json"})
    public Response authHeader(@Context HttpHeaders headers) {
        StringBuilder theEntity = new StringBuilder("{");
        Iterator headerIt = headers.getRequestHeaders().entrySet().iterator();
        while (headerIt.hasNext()) {
            Map.Entry header = (Map.Entry)headerIt.next();
            if (((List)header.getValue()).size() != 1) {
                throw new IllegalArgumentException("Mutlivalued header: " + (String)header.getKey());
            }
            theEntity.append("\"").append((String)header.getKey()).append("\":\"").append((String)((List)header.getValue()).get(0)).append("\"");
            if (!headerIt.hasNext()) continue;
            theEntity.append(", ");
        }
        theEntity.append("}");
        return Response.ok().entity((Object)theEntity.toString()).build();
    }

    private int countNodesIn(GraphDatabaseService db) {
        int count = 0;
        for (Node node : db.getAllNodes()) {
            ++count;
        }
        return count;
    }
}

