/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.UniqueStrings;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.GraphDescription;

public class SchemaConstraintsDocIT
extends AbstractRestFunctionalTestBase {
    private final Factory<String> labels = UniqueStrings.withPrefix("label");
    private final Factory<String> properties = UniqueStrings.withPrefix("property");
    private final Factory<String> relationshipTypes = UniqueStrings.withPrefix("relationshipType");

    @Documented(value="Create uniqueness constraint.\nCreate a uniqueness constraint on a property.")
    @Test
    @GraphDescription.Graph(nodes={})
    public void createPropertyUniquenessConstraint() throws JsonParseException {
        this.data.get();
        String labelName = (String)this.labels.newInstance();
        String propertyKey = (String)this.properties.newInstance();
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Collections.singletonList(propertyKey)});
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(JsonHelper.createJsonFrom((Object)definition)).post(this.getSchemaConstraintLabelUniquenessUri(labelName)).entity();
        Map serialized = JsonHelper.jsonToMap((String)result);
        HashMap<String, Object> constraint = new HashMap<String, Object>();
        constraint.put("type", ConstraintType.UNIQUENESS.name());
        constraint.put("label", labelName);
        constraint.put("property_keys", Collections.singletonList(propertyKey));
        Assert.assertThat((Object)serialized, (Matcher)Matchers.equalTo(constraint));
    }

    @Documented(value="Get a specific uniqueness constraint.\nGet a specific uniqueness constraint for a label and a property.")
    @Test
    @GraphDescription.Graph(nodes={})
    public void getLabelUniquenessPropertyConstraint() throws JsonParseException {
        this.data.get();
        String labelName = (String)this.labels.newInstance();
        String propertyKey = (String)this.properties.newInstance();
        this.createLabelUniquenessPropertyConstraint(labelName, propertyKey);
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.getSchemaConstraintLabelUniquenessPropertyUri(labelName, propertyKey)).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        HashMap<String, Object> constraint = new HashMap<String, Object>();
        constraint.put("type", ConstraintType.UNIQUENESS.name());
        constraint.put("label", labelName);
        constraint.put("property_keys", Collections.singletonList(propertyKey));
        Assert.assertThat((Object)serializedList, (Matcher)Matchers.hasItem(constraint));
    }

    @Documented(value="Get all uniqueness constraints for a label.")
    @Test
    @GraphDescription.Graph(nodes={})
    public void getLabelUniquenessPropertyConstraints() throws JsonParseException {
        this.data.get();
        String labelName = (String)this.labels.newInstance();
        String propertyKey1 = (String)this.properties.newInstance();
        String propertyKey2 = (String)this.properties.newInstance();
        this.createLabelUniquenessPropertyConstraint(labelName, propertyKey1);
        this.createLabelUniquenessPropertyConstraint(labelName, propertyKey2);
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.getSchemaConstraintLabelUniquenessUri(labelName)).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        HashMap<String, Object> constraint1 = new HashMap<String, Object>();
        constraint1.put("type", ConstraintType.UNIQUENESS.name());
        constraint1.put("label", labelName);
        constraint1.put("property_keys", Collections.singletonList(propertyKey1));
        HashMap<String, Object> constraint2 = new HashMap<String, Object>();
        constraint2.put("type", ConstraintType.UNIQUENESS.name());
        constraint2.put("label", labelName);
        constraint2.put("property_keys", Collections.singletonList(propertyKey2));
        Assert.assertThat((Object)serializedList, (Matcher)Matchers.hasItems((Object[])new Map[]{constraint1, constraint2}));
    }

    @Documented(value="Get all constraints for a label.")
    @Test
    @GraphDescription.Graph(nodes={})
    public void getLabelPropertyConstraints() throws JsonParseException {
        this.data.get();
        String labelName = (String)this.labels.newInstance();
        String propertyKey1 = (String)this.properties.newInstance();
        this.createLabelUniquenessPropertyConstraint(labelName, propertyKey1);
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.getSchemaConstraintLabelUri(labelName)).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        HashMap<String, Object> constraint1 = new HashMap<String, Object>();
        constraint1.put("type", ConstraintType.UNIQUENESS.name());
        constraint1.put("label", labelName);
        constraint1.put("property_keys", Collections.singletonList(propertyKey1));
        Assert.assertThat((Object)serializedList, (Matcher)Matchers.hasItems((Object[])new Map[]{constraint1}));
    }

    @Documented(value="Get all constraints.")
    @Test
    @GraphDescription.Graph(nodes={})
    public void get_constraints() throws JsonParseException {
        this.data.get();
        String labelName1 = (String)this.labels.newInstance();
        String propertyKey1 = (String)this.properties.newInstance();
        this.createLabelUniquenessPropertyConstraint(labelName1, propertyKey1);
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.getSchemaConstraintUri()).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        HashMap<String, Object> constraint1 = new HashMap<String, Object>();
        constraint1.put("type", ConstraintType.UNIQUENESS.name());
        constraint1.put("label", labelName1);
        constraint1.put("property_keys", Collections.singletonList(propertyKey1));
        Assert.assertThat((Object)serializedList, (Matcher)Matchers.hasItems((Object[])new Map[]{constraint1}));
    }

    @Documented(value="Drop uniqueness constraint.\nDrop uniqueness constraint for a label and a property.")
    @Test
    @GraphDescription.Graph(nodes={})
    public void drop_constraint() throws Exception {
        this.data.get();
        String labelName = (String)this.labels.newInstance();
        String propertyKey = (String)this.properties.newInstance();
        ConstraintDefinition constraintDefinition = this.createLabelUniquenessPropertyConstraint(labelName, propertyKey);
        Assert.assertThat((Object)Neo4jMatchers.getConstraints((GraphDatabaseService)this.graphdb(), (Label)Label.label((String)labelName)), (Matcher)Neo4jMatchers.containsOnly((Object[])new ConstraintDefinition[]{constraintDefinition}));
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(204).delete(this.getSchemaConstraintLabelUniquenessPropertyUri(labelName, propertyKey)).entity();
        Assert.assertThat((Object)Neo4jMatchers.getConstraints((GraphDatabaseService)this.graphdb(), (Label)Label.label((String)labelName)), (Matcher)Neo4jMatchers.isEmpty());
    }

    @Test
    public void create_existing_constraint() {
        String labelName = (String)this.labels.newInstance();
        String propertyKey = (String)this.properties.newInstance();
        this.createLabelUniquenessPropertyConstraint(labelName, propertyKey);
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Collections.singletonList(propertyKey)});
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(409).payload(JsonHelper.createJsonFrom((Object)definition)).post(this.getSchemaConstraintLabelUniquenessUri(labelName)).entity();
    }

    @Test
    public void drop_non_existent_constraint() throws Exception {
        String labelName = (String)this.labels.newInstance();
        String propertyKey = (String)this.properties.newInstance();
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(404).delete(this.getSchemaConstraintLabelUniquenessPropertyUri(labelName, propertyKey));
    }

    @Test
    public void create_compound_schema_index() {
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Arrays.asList((String)this.properties.newInstance(), (String)this.properties.newInstance())});
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(400).payload(JsonHelper.createJsonFrom((Object)definition)).post(this.getSchemaIndexLabelUri((String)this.labels.newInstance()));
    }

    private ConstraintDefinition createLabelUniquenessPropertyConstraint(String labelName, String propertyKey) {
        try (Transaction tx = this.graphdb().beginTx();){
            ConstraintDefinition constraintDefinition = this.graphdb().schema().constraintFor(Label.label((String)labelName)).assertPropertyIsUnique(propertyKey).create();
            tx.success();
            ConstraintDefinition constraintDefinition2 = constraintDefinition;
            return constraintDefinition2;
        }
    }
}

