/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.net.URI;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.server.rest.dbms.UserService;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.server.security.auth.AuthManager;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.User;
import org.neo4j.test.server.EntityOutputFormat;

public class UserServiceTest {
    private static final Principal NEO4J_PRINCIPLE = new Principal(){

        @Override
        public String getName() {
            return "neo4j";
        }
    };
    private static final User NEO4J_USER = new User("neo4j", Credential.forPassword((String)"neo4j"), true);

    @Test
    public void shouldReturnValidUserRepresentation() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        AuthManager authManager = (AuthManager)Mockito.mock(AuthManager.class);
        Mockito.when((Object)authManager.getUser("neo4j")).thenReturn((Object)NEO4J_USER);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(authManager, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.getUser("neo4j", req);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"username\" : \"neo4j\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"password_change\" : \"http://www.example.com/user/neo4j/password\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"password_change_required\" : true"));
    }

    @Test
    public void shouldReturn404WhenRequestingUserIfNotAuthenticated() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)Mockito.mock(AuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.getUser("neo4j", req);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
    }

    @Test
    public void shouldReturn404WhenRequestingUserIfDifferentUser() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)Mockito.mock(AuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.getUser("fred", req);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
    }

    @Test
    public void shouldReturn404WhenRequestingUserIfUnknownUser() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        AuthManager authManager = (AuthManager)Mockito.mock(AuthManager.class);
        Mockito.when((Object)authManager.getUser("neo4j")).thenReturn(null);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(authManager, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.getUser("neo4j", req);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
    }

    @Test
    public void shouldChangePasswordAndReturnSuccess() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        AuthManager authManager = (AuthManager)Mockito.mock(AuthManager.class);
        Mockito.when((Object)authManager.getUser("neo4j")).thenReturn((Object)NEO4J_USER);
        Mockito.when((Object)authManager.setPassword("neo4j", "test")).thenReturn((Object)NEO4J_USER);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(authManager, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : \"test\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        ((AuthManager)Mockito.verify((Object)authManager)).setPassword("neo4j", "test");
    }

    @Test
    public void shouldReturn404WhenChangingPasswordIfNotAuthenticated() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn(null);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)Mockito.mock(AuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : \"test\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
    }

    @Test
    public void shouldReturn404WhenChangingPasswordIfDifferentUser() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        AuthManager authManager = (AuthManager)Mockito.mock(AuthManager.class);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(authManager, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("fred", req, "{ \"password\" : \"test\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
        Mockito.verifyZeroInteractions((Object[])new Object[]{authManager});
    }

    @Test
    public void shouldReturn404WhenChangingPasswordIfUnknownUser() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        AuthManager authManager = (AuthManager)Mockito.mock(AuthManager.class);
        Mockito.when((Object)authManager.getUser("neo4j")).thenReturn(null);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(authManager, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : \"test\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
        ((AuthManager)Mockito.verify((Object)authManager)).getUser("neo4j");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{authManager});
    }

    @Test
    public void shouldReturn400IfPayloadIsInvalid() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)Mockito.mock(AuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "xxx");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)400));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Request.InvalidFormat\""));
    }

    @Test
    public void shouldReturn422IfMissingPassword() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)Mockito.mock(AuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"unknown\" : \"unknown\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)422));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Request.InvalidFormat\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"message\" : \"Required parameter 'password' is missing.\""));
    }

    @Test
    public void shouldReturn422IfInvalidPasswordType() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)Mockito.mock(AuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : 1 }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)422));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Request.InvalidFormat\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"message\" : \"Expected 'password' to be a string.\""));
    }

    @Test
    public void shouldReturn422IfEmptyPassword() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)Mockito.mock(AuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : \"\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)422));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Request.Invalid\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"message\" : \"Password cannot be empty.\""));
    }

    @Test
    public void shouldReturn422IfPasswordIdentical() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        AuthManager authManager = (AuthManager)Mockito.mock(AuthManager.class);
        Mockito.when((Object)authManager.getUser("neo4j")).thenReturn((Object)NEO4J_USER);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(authManager, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : \"neo4j\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)422));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Request.Invalid\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"message\" : \"Old password and new password cannot be the same.\""));
    }
}

