/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;

class TransitionalTxManagementKernelTransaction {
    private final GraphDatabaseFacade db;
    private final KernelTransaction.Type type;
    private final AccessMode mode;
    private long customTransactionTimeout;
    private final ThreadToStatementContextBridge bridge;
    private InternalTransaction tx;
    private KernelTransaction suspendedTransaction;

    TransitionalTxManagementKernelTransaction(GraphDatabaseFacade db, KernelTransaction.Type type, AccessMode mode, long customTransactionTimeout, ThreadToStatementContextBridge bridge) {
        this.db = db;
        this.type = type;
        this.mode = mode;
        this.customTransactionTimeout = customTransactionTimeout;
        this.bridge = bridge;
        this.tx = this.startTransaction();
    }

    void suspendSinceTransactionsAreStillThreadBound() {
        assert (this.suspendedTransaction == null) : "Can't suspend the transaction if it already is suspended.";
        this.suspendedTransaction = this.bridge.getTopLevelTransactionBoundToThisThread(true);
        this.bridge.unbindTransactionFromCurrentThread();
    }

    void resumeSinceTransactionsAreStillThreadBound() {
        assert (this.suspendedTransaction != null) : "Can't resume the transaction if it has not first been suspended.";
        this.bridge.bindTransactionToCurrentThread(this.suspendedTransaction);
        this.suspendedTransaction = null;
    }

    public void terminate() {
        this.tx.terminate();
    }

    public void rollback() {
        try {
            KernelTransaction kernelTransactionBoundToThisThread = this.bridge.getKernelTransactionBoundToThisThread(false);
            kernelTransactionBoundToThisThread.failure();
            kernelTransactionBoundToThisThread.close();
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.bridge.unbindTransactionFromCurrentThread();
        }
    }

    public void commit() {
        try {
            KernelTransaction kernelTransactionBoundToThisThread = this.bridge.getKernelTransactionBoundToThisThread(true);
            kernelTransactionBoundToThisThread.success();
            kernelTransactionBoundToThisThread.close();
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.bridge.unbindTransactionFromCurrentThread();
        }
    }

    void closeTransactionForPeriodicCommit() {
        this.tx.close();
    }

    void reopenAfterPeriodicCommit() {
        this.tx = this.startTransaction();
    }

    private InternalTransaction startTransaction() {
        return this.customTransactionTimeout > 0L ? this.db.beginTransaction(this.type, this.mode, this.customTransactionTimeout) : this.db.beginTransaction(this.type, this.mode);
    }
}

