/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web.logging;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class HTTPLoggingIT
extends ExclusiveServerTestBase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses() throws Exception {
        File logDirectory = this.testDirectory.directory("givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses-logdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)logDirectory);
        File confDir = this.testDirectory.directory("givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses-confdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)confDir);
        CommunityNeoServer server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withProperty(ServerSettings.http_logging_enabled.name(), "false").withProperty(GraphDatabaseSettings.logs_directory.name(), logDirectory.toString()).usingDataDir(this.testDirectory.directory("givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses-dbdir").getAbsolutePath()).build();
        try {
            server.start();
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
            String query = "?implicitlyDisabled" + this.randomString();
            JaxRsResponse response = new RestRequest().get(functionalTestHelper.managementUri() + query);
            Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
            response.close();
            File httpLog = new File(logDirectory, "http.log");
            Assert.assertThat((Object)httpLog.exists(), (Matcher)CoreMatchers.is((Object)false));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess() throws Exception {
        File logDirectory = this.testDirectory.directory("givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess-logdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)logDirectory);
        System.out.println(logDirectory);
        File confDir = this.testDirectory.directory("givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess-confdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)confDir);
        String query = "?explicitlyEnabled=" + this.randomString();
        CommunityNeoServer server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withProperty(ServerSettings.http_logging_enabled.name(), "true").withProperty(GraphDatabaseSettings.logs_directory.name(), logDirectory.getAbsolutePath()).usingDataDir(this.testDirectory.directory("givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess-dbdir").getAbsolutePath()).build();
        try {
            server.start();
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
            JaxRsResponse response = new RestRequest().get(functionalTestHelper.managementUri() + query);
            Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
            response.close();
            File httpLog = new File(logDirectory, "http.log");
            org.neo4j.test.Assert.assertEventually((String)"request appears in log", this.fileContentSupplier(httpLog), (Matcher)Matchers.containsString((String)query), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        finally {
            server.stop();
        }
    }

    private ThrowingSupplier<String, IOException> fileContentSupplier(File file) {
        return () -> FileUtils.readTextFile((File)file, (Charset)StandardCharsets.UTF_8);
    }

    private String randomString() {
        return UUID.randomUUID().toString();
    }
}

