/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.test.GraphDescription;

public class LabelsIT
extends AbstractRestFunctionalTestBase {
    @Documented(value="Adding a label to a node.")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Clint Eastwood", setNameProperty=true)})
    public void adding_a_label_to_a_node() throws PropertyValueException {
        Map nodes = (Map)this.data.get();
        String nodeUri = this.getNodeUri((Node)nodes.get("Clint Eastwood"));
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(204).payload(JsonHelper.createJsonFrom((Object)"Person")).post(nodeUri + "/labels");
    }

    @Documented(value="Adding multiple labels to a node.")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Clint Eastwood", setNameProperty=true)})
    public void adding_multiple_labels_to_a_node() throws PropertyValueException {
        Map nodes = (Map)this.data.get();
        String nodeUri = this.getNodeUri((Node)nodes.get("Clint Eastwood"));
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(204).payload(JsonHelper.createJsonFrom((Object)new String[]{"Person", "Actor"})).post(nodeUri + "/labels");
        Assert.assertThat(nodes.get("Clint Eastwood"), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Neo4jMatchers.hasLabels((String[])new String[]{"Person", "Actor"})));
    }

    @Documented(value="Adding a label with an invalid name.\n\nLabels with empty names are not allowed, however, all other valid strings are accepted as label names.\nAdding an invalid label to a node will lead to a HTTP 400 response.")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Clint Eastwood", setNameProperty=true)})
    public void adding_an_invalid_label_to_a_node() throws PropertyValueException {
        Map nodes = (Map)this.data.get();
        String nodeUri = this.getNodeUri((Node)nodes.get("Clint Eastwood"));
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(400).payload(JsonHelper.createJsonFrom((Object)"")).post(nodeUri + "/labels");
    }

    @Documented(value="Replacing labels on a node.\n\nThis removes any labels currently on a node, and replaces them with the labels passed in as the\nrequest body.")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Clint Eastwood", setNameProperty=true, labels={@GraphDescription.LABEL(value="Person")})})
    public void replacing_labels_on_a_node() throws PropertyValueException {
        Map nodes = (Map)this.data.get();
        String nodeUri = this.getNodeUri((Node)nodes.get("Clint Eastwood"));
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(204).payload(JsonHelper.createJsonFrom((Object)new String[]{"Actor", "Director"})).put(nodeUri + "/labels");
        Assert.assertThat(nodes.get("Clint Eastwood"), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Neo4jMatchers.hasLabels((String[])new String[]{"Actor", "Director"})));
    }

    @Documented(value="Listing labels for a node.")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Clint Eastwood", labels={@GraphDescription.LABEL(value="Actor"), @GraphDescription.LABEL(value="Director")}, setNameProperty=true)})
    public void listing_node_labels() throws JsonParseException {
        Map nodes = (Map)this.data.get();
        String nodeUri = this.getNodeUri((Node)nodes.get("Clint Eastwood"));
        String body = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(nodeUri + "/labels").entity();
        List labels = (List)JsonHelper.readJson((String)body);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new String[]{"Actor", "Director"}), (Object)Iterables.asSet((Iterable)labels));
    }

    @Documented(value="Removing a label from a node.")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Clint Eastwood", setNameProperty=true, labels={@GraphDescription.LABEL(value="Person")})})
    public void removing_a_label_from_a_node() throws PropertyValueException {
        Map nodes = (Map)this.data.get();
        Node node = (Node)nodes.get("Clint Eastwood");
        String nodeUri = this.getNodeUri(node);
        String labelName = "Person";
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(204).delete(nodeUri + "/labels/" + labelName);
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Matchers.not((Matcher)Neo4jMatchers.hasLabel((Label)Label.label((String)labelName)))));
    }

    @Documented(value="Removing a non-existent label from a node.")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Clint Eastwood", setNameProperty=true)})
    public void removing_a_non_existent_label_from_a_node() throws PropertyValueException {
        Map nodes = (Map)this.data.get();
        Node node = (Node)nodes.get("Clint Eastwood");
        String nodeUri = this.getNodeUri(node);
        String labelName = "Person";
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(204).delete(nodeUri + "/labels/" + labelName);
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Matchers.not((Matcher)Neo4jMatchers.hasLabel((Label)Label.label((String)labelName)))));
    }

    @Documented(value="Get all nodes with a label.")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Clint Eastwood", setNameProperty=true, labels={@GraphDescription.LABEL(value="Actor"), @GraphDescription.LABEL(value="Director")}), @GraphDescription.NODE(name="Donald Sutherland", setNameProperty=true, labels={@GraphDescription.LABEL(value="Actor")}), @GraphDescription.NODE(name="Steven Spielberg", setNameProperty=true, labels={@GraphDescription.LABEL(value="Director")})})
    public void get_all_nodes_with_label() throws JsonParseException {
        this.data.get();
        String uri = this.getNodesWithLabelUri("Actor");
        String body = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(uri).entity();
        List parsed = (List)JsonHelper.readJson((String)body);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new String[]{"Clint Eastwood", "Donald Sutherland"}), (Object)Iterables.asSet((Iterable)Iterables.map(this.getProperty("name", String.class), (Iterable)parsed)));
    }

    @Test
    @Documented(value="Get nodes by label and property.\n\nYou can retrieve all nodes with a given label and property by passing one property as a query parameter.\nNotice that the property value is JSON-encoded and then URL-encoded.\n\nIf there is an index available on the label/property combination you send, that index will be used. If no\nindex is available, all nodes with the given label will be filtered through to find matching nodes.\n\nCurrently, it is not possible to search using multiple properties.")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Donald Sutherland", labels={@GraphDescription.LABEL(value="Person")}), @GraphDescription.NODE(name="Clint Eastwood", labels={@GraphDescription.LABEL(value="Person")}, properties={@GraphDescription.PROP(key="name", value="Clint Eastwood")}), @GraphDescription.NODE(name="Steven Spielberg", labels={@GraphDescription.LABEL(value="Person")}, properties={@GraphDescription.PROP(key="name", value="Steven Spielberg")})})
    public void get_nodes_with_label_and_property() throws JsonParseException, UnsupportedEncodingException {
        this.data.get();
        String labelName = "Person";
        String result = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(this.getNodesWithLabelAndPropertyUri(labelName, "name", "Clint Eastwood")).entity();
        List parsed = (List)JsonHelper.readJson((String)result);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new String[]{"Clint Eastwood"}), (Object)Iterables.asSet((Iterable)Iterables.map(this.getProperty("name", String.class), (Iterable)parsed)));
    }

    @Test
    @Documented(value="Get nodes by label and array property.")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Donald Sutherland", labels={@GraphDescription.LABEL(value="Person")}), @GraphDescription.NODE(name="Clint Eastwood", labels={@GraphDescription.LABEL(value="Person")}, properties={@GraphDescription.PROP(key="names", value="Clint,Eastwood", type=GraphDescription.PropType.ARRAY, componentType=GraphDescription.PropType.STRING)}), @GraphDescription.NODE(name="Steven Spielberg", labels={@GraphDescription.LABEL(value="Person")}, properties={@GraphDescription.PROP(key="names", value="Steven,Spielberg", type=GraphDescription.PropType.ARRAY, componentType=GraphDescription.PropType.STRING)})})
    public void get_nodes_with_label_and_array_property() throws JsonParseException, UnsupportedEncodingException {
        this.data.get();
        String labelName = "Person";
        String uri = this.getNodesWithLabelAndPropertyUri(labelName, "names", new String[]{"Clint", "Eastwood"});
        String result = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(uri).entity();
        List parsed = (List)JsonHelper.readJson((String)result);
        Assert.assertEquals((long)1L, (long)parsed.size());
        Assert.assertEquals((Object)Iterables.asSet(Arrays.asList(Arrays.asList("Clint", "Eastwood"))), (Object)Iterables.asSet((Iterable)Iterables.map(this.getProperty("names", List.class), (Iterable)parsed)));
    }

    @Test
    @Documented(value="List all labels.\n \nBy default, the server will return labels in use only. If you also want to return labels not in use,\nappend the \"in_use=0\" query parameter.")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Clint Eastwood", setNameProperty=true, labels={@GraphDescription.LABEL(value="Person"), @GraphDescription.LABEL(value="Actor"), @GraphDescription.LABEL(value="Director")}), @GraphDescription.NODE(name="Donald Sutherland", setNameProperty=true, labels={@GraphDescription.LABEL(value="Person"), @GraphDescription.LABEL(value="Actor")}), @GraphDescription.NODE(name="Steven Spielberg", setNameProperty=true, labels={@GraphDescription.LABEL(value="Person"), @GraphDescription.LABEL(value="Director")})})
    public void list_all_labels() throws JsonParseException {
        this.data.get();
        String uri = this.getLabelsUri();
        String body = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(uri).entity();
        Set parsed = Iterables.asSet((Iterable)((List)JsonHelper.readJson((String)body)));
        Assert.assertTrue((boolean)parsed.contains("Person"));
        Assert.assertTrue((boolean)parsed.contains("Actor"));
        Assert.assertTrue((boolean)parsed.contains("Director"));
    }

    private <T> Function<Object, T> getProperty(String propertyKey, Class<T> propertyType) {
        return from -> {
            Map node = (Map)from;
            Map data1 = (Map)node.get("data");
            return propertyType.cast(data1.get(propertyKey));
        };
    }
}

