/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.repr.DiscoveryRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;

@Path(value="/")
public class DiscoveryService {
    private final Config config;
    private final OutputFormat outputFormat;

    public DiscoveryService(@Context Config config, @Context OutputFormat outputFormat) {
        this.config = config;
        this.outputFormat = outputFormat;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDiscoveryDocument() throws URISyntaxException {
        String managementUri = ((URI)this.config.get(ServerSettings.management_api_path)).getPath() + "/";
        String dataUri = ((URI)this.config.get(ServerSettings.rest_api_path)).getPath() + "/";
        String boltAddress = GraphDatabaseSettings.boltConnectors((Config)this.config).stream().findFirst().map(boltConnector -> ((AdvertisedSocketAddress)this.config.get(boltConnector.advertised_address)).toString()).orElse(null);
        return this.outputFormat.ok((Representation)new DiscoveryRepresentation(managementUri, dataUri, boltAddress));
    }

    @GET
    @Produces(value={"*/*"})
    public Response redirectToBrowser() {
        return this.outputFormat.seeOther((URI)this.config.get(ServerSettings.browser_path));
    }
}

