/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.rest.transactional.ExecutionResultSerializer;
import org.neo4j.server.rest.transactional.StatementDeserializer;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;
import org.neo4j.server.rest.transactional.error.TransactionLifecycleException;
import org.neo4j.server.rest.web.TransactionUriScheme;

public class TransactionFacade {
    private final TransitionalPeriodTransactionMessContainer kernel;
    private final QueryExecutionEngine engine;
    private final TransactionRegistry registry;
    private final LogProvider logProvider;
    private GraphDatabaseQueryService queryService;

    public TransactionFacade(TransitionalPeriodTransactionMessContainer kernel, QueryExecutionEngine engine, GraphDatabaseQueryService queryService, TransactionRegistry registry, LogProvider logProvider) {
        this.kernel = kernel;
        this.engine = engine;
        this.queryService = queryService;
        this.registry = registry;
        this.logProvider = logProvider;
    }

    public TransactionHandle newTransactionHandle(TransactionUriScheme uriScheme, boolean implicitTransaction, AccessMode mode, long customTransactionTimeout) throws TransactionLifecycleException {
        return new TransactionHandle(this.kernel, this.engine, this.queryService, this.registry, uriScheme, implicitTransaction, mode, customTransactionTimeout, this.logProvider);
    }

    public TransactionHandle findTransactionHandle(long txId) throws TransactionLifecycleException {
        return this.registry.acquire(txId);
    }

    public TransactionHandle terminate(long txId) throws TransactionLifecycleException {
        return this.registry.terminate(txId);
    }

    public StatementDeserializer deserializer(InputStream input) {
        return new StatementDeserializer(input);
    }

    public ExecutionResultSerializer serializer(OutputStream output, URI baseUri) {
        return new ExecutionResultSerializer(output, baseUri, this.logProvider, this.kernel);
    }
}

