/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.HttpRequestContext;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.neo4j.kernel.api.security.AccessMode;

public class AuthorizedRequestWrapper
extends HttpServletRequestWrapper {
    private final String authType;
    private final DelegatingPrinciple principle;

    public static final AccessMode getAccessModeFromHttpServletRequest(HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        return AuthorizedRequestWrapper.getAccessModeFromUserPrincipal(principal);
    }

    public static final AccessMode getAccessModeFromHttpContext(HttpContext httpContext) {
        HttpRequestContext requestContext = httpContext.getRequest();
        Principal principal = requestContext.getUserPrincipal();
        return AuthorizedRequestWrapper.getAccessModeFromUserPrincipal(principal);
    }

    private static final AccessMode getAccessModeFromUserPrincipal(Principal principal) {
        if (principal instanceof DelegatingPrinciple) {
            return ((DelegatingPrinciple)principal).getAccessMode();
        }
        return AccessMode.Static.NONE;
    }

    public AuthorizedRequestWrapper(String authType, String username, HttpServletRequest request, AccessMode accessMode) {
        super(request);
        this.authType = authType;
        this.principle = new DelegatingPrinciple(username, accessMode);
    }

    public String getAuthType() {
        return this.authType;
    }

    public Principal getUserPrincipal() {
        return this.principle;
    }

    public boolean isUserInRole(String role) {
        return true;
    }

    public String toString() {
        return "AuthorizedRequestWrapper{authType='" + this.authType + '\'' + ", principle=" + this.principle + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AuthorizedRequestWrapper that = (AuthorizedRequestWrapper)((Object)o);
        if (!this.authType.equals(that.authType)) {
            return false;
        }
        return this.principle.equals(that.principle);
    }

    public int hashCode() {
        int result = this.authType.hashCode();
        result = 31 * result + this.principle.hashCode();
        return result;
    }

    public class DelegatingPrinciple
    implements Principal {
        private String username;
        private final AccessMode accessMode;

        private DelegatingPrinciple(String username, AccessMode accessMode) {
            this.username = username;
            this.accessMode = accessMode;
        }

        @Override
        public String getName() {
            return this.username;
        }

        public AccessMode getAccessMode() {
            return this.accessMode;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DelegatingPrinciple)) {
                return false;
            }
            DelegatingPrinciple that = (DelegatingPrinciple)o;
            return this.username.equals(that.username);
        }

        @Override
        public int hashCode() {
            return this.username.hashCode();
        }

        @Override
        public String toString() {
            return "DelegatingPrinciple{username='" + this.username + '\'' + '}';
        }
    }
}

