/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.exception.InvalidArgumentsException;
import org.neo4j.server.rest.dbms.UserService;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.PasswordPolicy;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserManager;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.test.server.EntityOutputFormat;

public class UserServiceTest {
    private static final Principal NEO4J_PRINCIPLE = new Principal(){

        @Override
        public String getName() {
            return "neo4j";
        }
    };
    private static final User NEO4J_USER = new User.Builder("neo4j", Credential.forPassword((String)"neo4j")).withRequiredPasswordChange(true).build();
    private final PasswordPolicy passwordPolicy = new BasicPasswordPolicy();
    private final InMemoryUserRepository userRepository = new InMemoryUserRepository();
    private final AuthManager authManager = new BasicAuthManager((UserRepository)this.userRepository, this.passwordPolicy, (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class));
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws InvalidArgumentsException, IOException {
        this.userRepository.create(NEO4J_USER);
    }

    @After
    public void tearDown() throws InvalidArgumentsException, IOException {
        this.userRepository.delete(NEO4J_USER);
    }

    @Test
    public void shouldReturnValidUserRepresentation() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        BasicAuthManager authManager = (BasicAuthManager)Mockito.mock(BasicAuthManager.class);
        UserManager userManager = (UserManager)Mockito.mock(UserManager.class);
        Mockito.when((Object)authManager.getUserManager()).thenReturn((Object)userManager);
        Mockito.when((Object)userManager.getUser("neo4j")).thenReturn((Object)NEO4J_USER);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)authManager, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.getUser("neo4j", req);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"username\" : \"neo4j\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"password_change\" : \"http://www.example.com/user/neo4j/password\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"password_change_required\" : true"));
    }

    @Test
    public void shouldReturn404WhenRequestingUserIfNotAuthenticated() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn(null);
        BasicAuthManager authManager = (BasicAuthManager)Mockito.mock(BasicAuthManager.class);
        UserManager userManager = (UserManager)Mockito.mock(UserManager.class);
        Mockito.when((Object)authManager.getUserManager()).thenReturn((Object)userManager);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)authManager, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.getUser("neo4j", req);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
    }

    @Test
    public void shouldReturn404WhenRequestingUserIfDifferentUser() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)Mockito.mock(BasicAuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.getUser("fred", req);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
    }

    @Test
    public void shouldReturn404WhenRequestingUserIfUnknownUser() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        BasicAuthManager authManager = (BasicAuthManager)Mockito.mock(BasicAuthManager.class);
        UserManager userManager = (UserManager)Mockito.mock(UserManager.class);
        Mockito.when((Object)authManager.getUserManager()).thenReturn((Object)userManager);
        Mockito.when((Object)userManager.getUser("neo4j")).thenThrow(new Throwable[]{new InvalidArgumentsException("User 'neo4j' does not exist!")});
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)authManager, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.getUser("neo4j", req);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
    }

    @Test
    public void shouldChangePasswordAndReturnSuccess() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        BasicAuthManager authManager = (BasicAuthManager)Mockito.mock(BasicAuthManager.class);
        UserManager userManager = (UserManager)Mockito.mock(UserManager.class);
        Mockito.when((Object)authManager.getUserManager()).thenReturn((Object)userManager);
        Mockito.when((Object)userManager.getUser("neo4j")).thenReturn((Object)NEO4J_USER);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)authManager, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : \"test\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        ((UserManager)Mockito.verify((Object)userManager)).setUserPassword("neo4j", "test");
    }

    @Test
    public void shouldReturn404WhenChangingPasswordIfNotAuthenticated() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn(null);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)Mockito.mock(BasicAuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : \"test\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
    }

    @Test
    public void shouldReturn404WhenChangingPasswordIfDifferentUser() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        BasicAuthManager authManager = (BasicAuthManager)Mockito.mock(BasicAuthManager.class);
        UserManager userManager = (UserManager)Mockito.mock(UserManager.class);
        Mockito.when((Object)authManager.getUserManager()).thenReturn((Object)userManager);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)authManager, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("fred", req, "{ \"password\" : \"test\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
        Mockito.verifyZeroInteractions((Object[])new Object[]{userManager});
    }

    @Test
    public void shouldReturn422WhenChangingPasswordIfUnknownUser() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(this.authManager, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        this.userRepository.delete(NEO4J_USER);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : \"test\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)422));
    }

    @Test
    public void shouldReturn400IfPayloadIsInvalid() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)Mockito.mock(BasicAuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "xxx");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)400));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Request.InvalidFormat\""));
    }

    @Test
    public void shouldReturn422IfMissingPassword() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)Mockito.mock(BasicAuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"unknown\" : \"unknown\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)422));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Request.InvalidFormat\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"message\" : \"Required parameter 'password' is missing.\""));
    }

    @Test
    public void shouldReturn422IfInvalidPasswordType() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((AuthManager)Mockito.mock(BasicAuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : 1 }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)422));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Request.InvalidFormat\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"message\" : \"Expected 'password' to be a string.\""));
    }

    @Test
    public void shouldReturn422IfEmptyPassword() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(this.authManager, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : \"\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)422));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Security.InvalidArguments\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"message\" : \"Password cannot be empty.\""));
    }

    @Test
    public void shouldReturn422IfPasswordIdentical() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)NEO4J_PRINCIPLE);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(this.authManager, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : \"neo4j\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)422));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Security.InvalidArguments\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"message\" : \"Old password and new password cannot be the same.\""));
    }

    @Test
    public void shouldThrowExceptionIfGivenAuthManagerDoesNotImplementUserManager() throws URISyntaxException {
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("The provided auth manager is not capable of user management");
        new UserService((AuthManager)Mockito.mock(AuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
    }
}

