/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.server.rest.transactional.Statement;
import org.neo4j.server.rest.transactional.StatementDeserializer;
import org.neo4j.server.rest.transactional.error.Neo4jError;

public class StubStatementDeserializer
extends StatementDeserializer {
    private final Iterator<Statement> statements;
    private final Iterator<Neo4jError> errors;
    private boolean hasNext;
    private Statement next;

    public static StubStatementDeserializer statements(Statement ... statements) {
        return new StubStatementDeserializer((Iterator<Neo4jError>)Iterators.emptyIterator(), Iterators.iterator((Object[])statements));
    }

    public StubStatementDeserializer(Iterator<Neo4jError> errors, Iterator<Statement> statements) {
        super((InputStream)new ByteArrayInputStream(new byte[0]));
        this.statements = statements;
        this.errors = errors;
        this.computeNext();
    }

    private void computeNext() {
        this.hasNext = this.statements.hasNext();
        this.next = this.hasNext ? this.statements.next() : null;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Statement peek() {
        if (this.hasNext) {
            return this.next;
        }
        throw new NoSuchElementException();
    }

    public Statement next() {
        Statement result = this.next;
        this.computeNext();
        return result;
    }

    public Iterator<Neo4jError> errors() {
        return this.errors;
    }
}

