/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.neo4j.concurrent.AsyncEvents;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;
import org.neo4j.logging.async.AsyncLogEvent;
import org.neo4j.logging.async.AsyncLogProvider;

public class AsyncRequestLog
extends AbstractLifeCycle
implements RequestLog,
Consumer<AsyncLogEvent>,
AsyncEvents.Monitor {
    private final Log log;
    private final ExecutorService asyncLogProcessingExecutor;
    private final AsyncEvents<AsyncLogEvent> asyncEventProcessor;

    public AsyncRequestLog(FileSystemAbstraction fs, String logFile, long rotationSize, int rotationKeepNumber) throws IOException {
        NamedThreadFactory threadFactory = new NamedThreadFactory("HTTP-Log-Rotator", true);
        ExecutorService rotationExecutor = Executors.newCachedThreadPool((ThreadFactory)threadFactory);
        RotatingFileOutputStreamSupplier outputSupplier = new RotatingFileOutputStreamSupplier(fs, new File(logFile), rotationSize, 0L, rotationKeepNumber, (Executor)rotationExecutor);
        FormattedLogProvider logProvider = FormattedLogProvider.withUTCTimeZone().toOutputStream((Supplier)outputSupplier);
        this.asyncLogProcessingExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("HTTP-Log-Writer"));
        this.asyncEventProcessor = new AsyncEvents((Consumer)this, (AsyncEvents.Monitor)this);
        AsyncLogProvider asyncLogProvider = new AsyncLogProvider(this.asyncEventProcessor, (LogProvider)logProvider);
        this.log = asyncLogProvider.getLog("REQUEST");
    }

    public void log(Request request, Response response) {
        String remoteHost = request.getRemoteHost();
        String user = request.getRemoteUser();
        String requestURL = request.getRequestURI() + "?" + request.getQueryString();
        int statusCode = response.getStatus();
        long length = response.getContentLength();
        String referer = request.getHeader("Referer");
        String userAgent = request.getHeader("User-Agent");
        long requestTimeStamp = request.getTimeStamp();
        long now = System.currentTimeMillis();
        long serviceTime = requestTimeStamp < 0L ? -1L : now - requestTimeStamp;
        this.log.info("%s - %s [%tc] \"%s\" %s %s \"%s\" \"%s\" %s", new Object[]{remoteHost, user, now, requestURL, statusCode, length, referer, userAgent, serviceTime});
    }

    protected synchronized void doStart() throws Exception {
        this.asyncLogProcessingExecutor.submit((Runnable)this.asyncEventProcessor);
        this.asyncEventProcessor.awaitStartup();
    }

    protected synchronized void doStop() throws Exception {
        this.asyncEventProcessor.shutdown();
    }

    @Override
    public void accept(AsyncLogEvent event) {
        event.process();
    }

    public void eventCount(long count) {
    }
}

