/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class NeoServerShutdownLoggingDocIT
extends ExclusiveServerTestBase {
    private AssertableLogProvider logProvider;
    private NeoServer server;

    @Before
    public void setupServer() throws IOException {
        this.logProvider = new AssertableLogProvider();
        this.server = ServerHelper.createNonPersistentServer((LogProvider)this.logProvider);
        ServerHelper.cleanTheDatabase(this.server);
    }

    @After
    public void shutdownTheServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void shouldLogShutdown() throws Exception {
        this.server.stop();
        this.logProvider.assertContainsMessageContaining("Stopped.");
    }
}

