/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.query.FakeTransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.server.rest.web.ServerQuerySession;

public class ServerQuerySessionTest {
    @Test
    public void shouldIncludeUsernameInToString() {
        ServerQuerySession session = new ServerQuerySession(null, (TransactionalContext)new FakeTransactionalContext((AccessMode)AccessMode.Static.READ));
        Assert.assertThat((Object)session.toString(), (Matcher)IsEqual.equalTo((Object)String.format("server-session\t%s", "READ")));
    }

    @Test
    public void shouldIncludeUsernameInToStringWithHttp() {
        HttpServletRequest mock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mock.getRemoteAddr()).thenReturn((Object)"remote-addr");
        Mockito.when((Object)mock.getRequestURI()).thenReturn((Object)"req-uri");
        ServerQuerySession session = new ServerQuerySession(mock, (TransactionalContext)new FakeTransactionalContext((AccessMode)AccessMode.Static.READ));
        Assert.assertThat((Object)session.toString(), (Matcher)IsEqual.equalTo((Object)String.format("server-session\thttp\t%s\t%s\t%s", "remote-addr", "req-uri", "READ")));
    }
}

