/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import javax.servlet.http.HttpServletRequest;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QuerySession;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.web.ServerQuerySession;

public class CypherExecutor
extends LifecycleAdapter {
    private final Database database;
    private ExecutionEngine executionEngine;
    private GraphDatabaseQueryService service;
    private ThreadToStatementContextBridge txBridge;
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();

    public CypherExecutor(Database database) {
        this.database = database;
    }

    public ExecutionEngine getExecutionEngine() {
        return this.executionEngine;
    }

    public void start() throws Throwable {
        DependencyResolver dependencyResolver = this.database.getGraph().getDependencyResolver();
        this.executionEngine = (ExecutionEngine)dependencyResolver.resolveDependency(QueryExecutionEngine.class);
        this.service = (GraphDatabaseQueryService)dependencyResolver.resolveDependency(GraphDatabaseQueryService.class);
        this.txBridge = (ThreadToStatementContextBridge)this.service.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }

    public void stop() throws Throwable {
        this.executionEngine = null;
        this.service = null;
        this.txBridge = null;
    }

    public QuerySession createSession(HttpServletRequest request) {
        InternalTransaction transaction = this.service.beginTransaction(KernelTransaction.Type.implicit, (AccessMode)AccessMode.Static.FULL);
        Neo4jTransactionalContext context = new Neo4jTransactionalContext(this.service, transaction, this.txBridge.get(), locker);
        return new ServerQuerySession(request, (TransactionalContext)context);
    }
}

