/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class NeoServerPortConflictDocIT
extends ExclusiveServerTestBase {
    @Test
    public void shouldComplainIfServerPortIsAlreadyTaken() throws IOException, InterruptedException {
        ListenSocketAddress contestedAddress = new ListenSocketAddress("localhost", 9999);
        try (ServerSocket ignored = new ServerSocket(contestedAddress.getPort(), 0, InetAddress.getByName(contestedAddress.getHostname()));){
            AssertableLogProvider logProvider = new AssertableLogProvider();
            CommunityNeoServer server = CommunityServerBuilder.server((LogProvider)logProvider).onAddress(contestedAddress).usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
            try {
                server.start();
                Assert.fail((String)"Should have reported failure to start");
            }
            catch (ServerStartupException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Starting Neo4j failed"));
            }
            logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog((Matcher)Matchers.containsString((String)"CommunityNeoServer")).error("Failed to start Neo4j on %s: %s", new Object[]{contestedAddress, String.format("Address %s is already in use, cannot bind to it.", contestedAddress)})});
            server.stop();
        }
    }

    @Test
    public void shouldComplainIfServerHTTPSPortIsAlreadyTaken() throws IOException, InterruptedException {
        ListenSocketAddress unContestedAddress = new ListenSocketAddress("localhost", 8888);
        ListenSocketAddress contestedAddress = new ListenSocketAddress("localhost", 9999);
        try (ServerSocket ignored = new ServerSocket(contestedAddress.getPort(), 0, InetAddress.getByName(contestedAddress.getHostname()));){
            AssertableLogProvider logProvider = new AssertableLogProvider();
            CommunityNeoServer server = CommunityServerBuilder.server((LogProvider)logProvider).onAddress(unContestedAddress).onHttpsAddress(contestedAddress).withHttpsEnabled().usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
            try {
                server.start();
                Assert.fail((String)"Should have reported failure to start");
            }
            catch (ServerStartupException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Starting Neo4j failed"));
            }
            logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog((Matcher)Matchers.containsString((String)"CommunityNeoServer")).error("Failed to start Neo4j on %s: %s", new Object[]{unContestedAddress, String.format("At least one of the addresses %s or %s is already in use, cannot bind to it.", unContestedAddress, contestedAddress)})});
            server.stop();
        }
    }
}

