/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryRegistryOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;

public class TransitionalPeriodTransactionMessContainerTest {
    private GraphDatabaseFacade databaseFacade = (GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class);
    private GraphDatabaseQueryService queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
    private HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    private DependencyResolver dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
    private Statement statement = (Statement)Mockito.mock(Statement.class);
    private ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
    private InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
    private KernelTransaction.Type type = KernelTransaction.Type.implicit;
    private AccessMode.Static accessMode = AccessMode.Static.FULL;

    @Before
    public void setUp() {
        Mockito.when((Object)this.statement.queryRegistration()).thenReturn(Mockito.mock(QueryRegistryOperations.class));
        Mockito.when((Object)this.bridge.get()).thenReturn((Object)this.statement);
        Mockito.when((Object)this.internalTransaction.transactionType()).thenReturn((Object)this.type);
        Mockito.when((Object)this.internalTransaction.mode()).thenReturn((Object)this.accessMode);
        Mockito.when((Object)this.databaseFacade.getDependencyResolver()).thenReturn((Object)this.dependencyResolver);
        Mockito.when((Object)this.queryService.getDependencyResolver()).thenReturn((Object)this.dependencyResolver);
        Mockito.when((Object)this.dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class)).thenReturn((Object)this.bridge);
    }

    @Test
    public void startTransactionWithCustomTimeout() throws Exception {
        Mockito.when((Object)this.databaseFacade.beginTransaction(this.type, (AccessMode)this.accessMode, 10L, TimeUnit.MILLISECONDS)).thenReturn((Object)this.internalTransaction);
        TransitionalPeriodTransactionMessContainer transactionMessContainer = new TransitionalPeriodTransactionMessContainer(this.databaseFacade);
        transactionMessContainer.create("create (n)", Collections.emptyMap(), this.queryService, this.type, (AccessMode)this.accessMode, 10L, this.request);
        ((GraphDatabaseFacade)Mockito.verify((Object)this.databaseFacade)).beginTransaction(this.type, (AccessMode)this.accessMode, 10L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void startDefaultTransactionWhenTimeoutNotSpecified() {
        Mockito.when((Object)this.databaseFacade.beginTransaction(this.type, (AccessMode)this.accessMode)).thenReturn((Object)this.internalTransaction);
        TransitionalPeriodTransactionMessContainer transactionMessContainer = new TransitionalPeriodTransactionMessContainer(this.databaseFacade);
        transactionMessContainer.create("create (n)", Collections.emptyMap(), this.queryService, this.type, (AccessMode)this.accessMode, 0L, this.request);
        ((GraphDatabaseFacade)Mockito.verify((Object)this.databaseFacade)).beginTransaction(this.type, (AccessMode)this.accessMode);
    }
}

