/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QuerySession;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.web.ServerQuerySession;
import org.neo4j.server.web.HttpHeaderUtils;

public class CypherExecutor
extends LifecycleAdapter {
    private final Database database;
    private ExecutionEngine executionEngine;
    private GraphDatabaseQueryService service;
    private ThreadToStatementContextBridge txBridge;
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private final Log log;

    public CypherExecutor(Database database, LogProvider logProvider) {
        this.database = database;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public ExecutionEngine getExecutionEngine() {
        return this.executionEngine;
    }

    public void start() throws Throwable {
        DependencyResolver dependencyResolver = this.database.getGraph().getDependencyResolver();
        this.executionEngine = (ExecutionEngine)dependencyResolver.resolveDependency(QueryExecutionEngine.class);
        this.service = (GraphDatabaseQueryService)dependencyResolver.resolveDependency(GraphDatabaseQueryService.class);
        this.txBridge = (ThreadToStatementContextBridge)dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class);
    }

    public void stop() throws Throwable {
        this.executionEngine = null;
        this.service = null;
        this.txBridge = null;
    }

    public QuerySession createSession(String query, Map<String, Object> parameters, HttpServletRequest request) {
        InternalTransaction transaction = this.getInternalTransaction(request);
        Neo4jTransactionalContext context = new Neo4jTransactionalContext(this.service, transaction, this.txBridge.get(), query, parameters, locker);
        return new ServerQuerySession(request, (TransactionalContext)context);
    }

    private InternalTransaction getInternalTransaction(HttpServletRequest request) {
        long customTimeout = HttpHeaderUtils.getTransactionTimeout(request, this.log);
        return customTimeout > 0L ? this.beginCustomTransaction(customTimeout) : this.beginDefaultTransaction();
    }

    private InternalTransaction beginCustomTransaction(long customTimeout) {
        return this.service.beginTransaction(KernelTransaction.Type.implicit, (AccessMode)AccessMode.Static.FULL, customTimeout, TimeUnit.MILLISECONDS);
    }

    private InternalTransaction beginDefaultTransaction() {
        return this.service.beginTransaction(KernelTransaction.Type.implicit, (AccessMode)AccessMode.Static.FULL);
    }
}

