/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.exception.InvalidArgumentsException;
import org.neo4j.server.rest.repr.AuthorizationRepresentation;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.ExceptionRepresentation;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.server.rest.web.CustomStatusType;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserManager;
import org.neo4j.server.security.auth.UserManagerSupplier;

@Path(value="/user")
public class UserService {
    public static final String PASSWORD = "password";
    private final UserManager userManager;
    private final InputFormat input;
    private final OutputFormat output;

    public UserService(@Context AuthManager authManager, @Context InputFormat input, @Context OutputFormat output) {
        if (!(authManager instanceof UserManagerSupplier)) {
            throw new IllegalArgumentException("The provided auth manager is not capable of user management");
        }
        this.userManager = ((UserManagerSupplier)authManager).getUserManager();
        this.input = input;
        this.output = output;
    }

    @GET
    @Path(value="/{username}")
    public Response getUser(@PathParam(value="username") String username, @Context HttpServletRequest req) {
        Principal principal = req.getUserPrincipal();
        if (principal == null || !principal.getName().equals(username)) {
            return this.output.notFound();
        }
        try {
            User user = this.userManager.getUser(username);
            return this.output.ok((Representation)new AuthorizationRepresentation(user));
        }
        catch (InvalidArgumentsException e) {
            return this.output.notFound();
        }
    }

    @POST
    @Path(value="/{username}/password")
    public Response setPassword(@PathParam(value="username") String username, @Context HttpServletRequest req, String payload) {
        Map deserialized;
        Principal principal = req.getUserPrincipal();
        if (principal == null || !principal.getName().equals(username)) {
            return this.output.notFound();
        }
        try {
            deserialized = this.input.readMap(payload, new String[0]);
        }
        catch (BadInputException e) {
            return this.output.response((Response.StatusType)Response.Status.BAD_REQUEST, (Representation)new ExceptionRepresentation(new Neo4jError((Status)Status.Request.InvalidFormat, e.getMessage())));
        }
        Object o = deserialized.get(PASSWORD);
        if (o == null) {
            return this.output.response(CustomStatusType.UNPROCESSABLE, (Representation)new ExceptionRepresentation(new Neo4jError((Status)Status.Request.InvalidFormat, String.format("Required parameter '%s' is missing.", PASSWORD))));
        }
        if (!(o instanceof String)) {
            return this.output.response(CustomStatusType.UNPROCESSABLE, (Representation)new ExceptionRepresentation(new Neo4jError((Status)Status.Request.InvalidFormat, String.format("Expected '%s' to be a string.", PASSWORD))));
        }
        String newPassword = (String)o;
        try {
            this.userManager.setUserPassword(username, newPassword, false);
        }
        catch (IOException e) {
            return this.output.serverErrorWithoutLegacyStacktrace(e);
        }
        catch (InvalidArgumentsException e) {
            return this.output.response(CustomStatusType.UNPROCESSABLE, (Representation)new ExceptionRepresentation(new Neo4jError(e.status(), e.getMessage())));
        }
        return this.output.ok();
    }
}

