/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;

public class SetNodePropertiesDocIT
extends AbstractRestFunctionalTestBase {
    @GraphDescription.Graph(value={"jim knows joe"})
    @Documented(value="Update node properties.\n\nThis will replace all existing properties on the node with the new set\nof attributes.")
    @Test
    public void shouldReturn204WhenPropertiesAreUpdated() throws JsonParseException {
        Node jim = (Node)((Map)this.data.get()).get("jim");
        Assert.assertThat((Object)jim, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)IsNot.not((Matcher)Neo4jMatchers.hasProperty((String)"age"))));
        ((RESTDocsGenerator)((Object)this.gen.get())).payload(JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"age", "18"}))).expectedStatus(204).put(this.getPropertiesUri(jim));
        Assert.assertThat((Object)jim, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Neo4jMatchers.hasProperty((String)"age").withValue((Object)"18")));
    }

    @GraphDescription.Graph(value={"jim knows joe"})
    @Test
    public void set_node_properties_in_Unicode() throws JsonParseException {
        Node jim = (Node)((Map)this.data.get()).get("jim");
        ((RESTDocsGenerator)((Object)this.gen.get())).payload(JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"name", "\u4f8b\u5b50"}))).expectedStatus(204).put(this.getPropertiesUri(jim));
        Assert.assertThat((Object)jim, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Neo4jMatchers.hasProperty((String)"name").withValue((Object)"\u4f8b\u5b50")));
    }

    @Test
    @GraphDescription.Graph(value={"jim knows joe"})
    public void shouldReturn400WhenSendinIncompatibleJsonProperties() throws JsonParseException {
        HashMap map = new HashMap();
        map.put("jim", new HashMap());
        ((RESTDocsGenerator)((Object)this.gen.get())).payload(JsonHelper.createJsonFrom(map)).expectedStatus(400).put(this.getPropertiesUri((Node)((Map)this.data.get()).get("jim")));
    }

    @Test
    @GraphDescription.Graph(value={"jim knows joe"})
    public void shouldReturn400WhenSendingCorruptJsonProperties() {
        JaxRsResponse response = RestRequest.req().put(this.getPropertiesUri((Node)((Map)this.data.get()).get("jim")), "this:::Is::notJSON}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
    }

    @Test
    @GraphDescription.Graph(value={"jim knows joe"})
    public void shouldReturn404WhenPropertiesSentToANodeWhichDoesNotExist() throws JsonParseException {
        ((RESTDocsGenerator)((Object)this.gen.get())).payload(JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"key", "val"}))).expectedStatus(404).put(SetNodePropertiesDocIT.getDataUri() + "node/12345/properties");
    }

    private URI getPropertyUri(Node node, String key) throws Exception {
        return new URI(this.getPropertiesUri(node) + "/" + key);
    }

    @Documented(value="Set property on node.\n\nSetting different properties will retain the existing ones for this node.\nNote that a single value are submitted not as a map but just as a value\n(which is valid JSON) like in the example\nbelow.")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="jim", properties={@GraphDescription.PROP(key="foo2", value="bar2")})})
    @Test
    public void shouldReturn204WhenPropertyIsSet() throws Exception {
        Node jim = (Node)((Map)this.data.get()).get("jim");
        ((RESTDocsGenerator)((Object)this.gen.get())).payload(JsonHelper.createJsonFrom((Object)"bar")).expectedStatus(204).put(this.getPropertyUri(jim, "foo").toString());
        Assert.assertThat((Object)jim, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Neo4jMatchers.hasProperty((String)"foo")));
        Assert.assertThat((Object)jim, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Neo4jMatchers.hasProperty((String)"foo2")));
    }

    @Documented(value="Property values can not be nested.\n\nNesting properties is not supported. You could for example store the\nnested JSON as a string instead.")
    @Test
    public void shouldReturn400WhenSendinIncompatibleJsonProperty() throws Exception {
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().payload("{\"foo\" : {\"bar\" : \"baz\"}}").expectedStatus(400).post(SetNodePropertiesDocIT.getDataUri() + "node/");
    }

    @Test
    @GraphDescription.Graph(value={"jim knows joe"})
    public void shouldReturn400WhenSendingCorruptJsonProperty() throws Exception {
        JaxRsResponse response = RestRequest.req().put(this.getPropertyUri((Node)((Map)this.data.get()).get("jim"), "foo"), "this:::Is::notJSON}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
    }

    @Test
    @GraphDescription.Graph(value={"jim knows joe"})
    public void shouldReturn404WhenPropertySentToANodeWhichDoesNotExist() throws Exception {
        JaxRsResponse response = RestRequest.req().put(SetNodePropertiesDocIT.getDataUri() + "node/1234/foo", JsonHelper.createJsonFrom((Object)"bar"));
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }
}

