/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.CypherResultRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class CypherResultRepresentationTest {
    @Rule
    public DatabaseRule database = new ImpermanentDatabaseRule();

    @Test
    public void shouldSerializeProfilingResult() throws Exception {
        String name = "Kalle";
        ExecutionPlanDescription plan = this.getMockDescription(name);
        ExecutionPlanDescription childPlan = this.getMockDescription("child");
        Mockito.when((Object)plan.getChildren()).thenReturn(Arrays.asList(childPlan));
        Mockito.when((Object)plan.hasProfilerStatistics()).thenReturn((Object)true);
        ExecutionPlanDescription.ProfilerStatistics stats = (ExecutionPlanDescription.ProfilerStatistics)Mockito.mock(ExecutionPlanDescription.ProfilerStatistics.class);
        Mockito.when((Object)stats.getDbHits()).thenReturn((Object)13L);
        Mockito.when((Object)stats.getRows()).thenReturn((Object)25L);
        Mockito.when((Object)plan.getProfilerStatistics()).thenReturn((Object)stats);
        Result result = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)result.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)result.columns()).thenReturn(new ArrayList());
        Mockito.when((Object)result.getExecutionPlanDescription()).thenReturn((Object)plan);
        Map<String, Object> serialized = this.serializeToStringThenParseAsToMap(new CypherResultRepresentation(result, false, true));
        Map serializedPlan = (Map)serialized.get("plan");
        Assert.assertThat((Object)((String)serializedPlan.get("name")), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat((Object)((Integer)serializedPlan.get("rows")), (Matcher)CoreMatchers.is((Object)25));
        Assert.assertThat((Object)((Integer)serializedPlan.get("dbHits")), (Matcher)CoreMatchers.is((Object)13));
        List children = (List)serializedPlan.get("children");
        Assert.assertThat((Object)children.size(), (Matcher)CoreMatchers.is((Object)1));
        Map args = (Map)serializedPlan.get("args");
        Assert.assertThat((Object)((String)args.get("argumentKey")), (Matcher)CoreMatchers.is((Object)"argumentValue"));
    }

    @Test
    public void shouldNotIncludePlanUnlessAskedFor() throws Exception {
        Result result = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)result.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)result.columns()).thenReturn(new ArrayList());
        Map<String, Object> serialized = this.serializeToStringThenParseAsToMap(new CypherResultRepresentation(result, false, false));
        Assert.assertFalse((String)"Didn't expect to see a plan here", (boolean)serialized.containsKey("plan"));
    }

    @Test
    public void shouldFormatMapsProperly() throws Exception {
        GraphDatabaseAPI graphdb = this.database.getGraphDatabaseAPI();
        Result result = graphdb.execute("RETURN {one:{two:['wait for it...', {three: 'GO!'}]}}");
        CypherResultRepresentation representation = new CypherResultRepresentation(result, false, false);
        Map<String, Object> serialized = this.serializeToStringThenParseAsToMap(representation);
        Map one = (Map)((Map)((List)((List)serialized.get("data")).get(0)).get(0)).get("one");
        List two = (List)one.get("two");
        Assert.assertThat((Object)((String)two.get(0)), (Matcher)CoreMatchers.is((Object)"wait for it..."));
        Map foo = (Map)two.get(1);
        Assert.assertThat((Object)((String)foo.get("three")), (Matcher)CoreMatchers.is((Object)"GO!"));
    }

    @Test
    public void shouldRenderNestedEntities() throws Exception {
        try (Transaction ignored = this.database.getGraphDatabaseAPI().beginTx();){
            GraphDatabaseAPI graphdb = this.database.getGraphDatabaseAPI();
            graphdb.execute("CREATE (n {name: 'Sally'}), (m {age: 42}), (n)-[r:FOO {drunk: false}]->(m)");
            Result result = graphdb.execute("MATCH p=(n)-[r]->(m) RETURN n, r, p, {node: n, edge: r, path: p}");
            CypherResultRepresentation representation = new CypherResultRepresentation(result, false, false);
            Map<String, Object> serialized = this.serializeToStringThenParseAsToMap(representation);
            Object firstRow = ((List)serialized.get("data")).get(0);
            Map nested = (Map)((List)firstRow).get(3);
            Assert.assertThat(nested.get("node"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(((List)firstRow).get(0))));
            Assert.assertThat(nested.get("edge"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(((List)firstRow).get(1))));
            Assert.assertThat(nested.get("path"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(((List)firstRow).get(2))));
        }
    }

    private ExecutionPlanDescription getMockDescription(String name) {
        ExecutionPlanDescription plan = (ExecutionPlanDescription)Mockito.mock(ExecutionPlanDescription.class);
        Mockito.when((Object)plan.getName()).thenReturn((Object)name);
        Mockito.when((Object)plan.getArguments()).thenReturn((Object)MapUtil.map((Object[])new Object[]{"argumentKey", "argumentValue"}));
        return plan;
    }

    private Map<String, Object> serializeToStringThenParseAsToMap(CypherResultRepresentation repr) throws Exception {
        OutputFormat format = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://localhost/"), null);
        return JsonHelper.jsonToMap((String)format.assemble((Representation)repr));
    }
}

