/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.server;

import java.util.concurrent.Callable;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.server.ServerHolder;

public class SharedServerTestBase {
    private static boolean useExternal = Boolean.valueOf(System.getProperty("neo-server.external", "false"));
    private static NeoServer server;
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    protected static NeoServer server() {
        return server;
    }

    @BeforeClass
    public static void allocateServer() throws Throwable {
        System.setProperty("org.neo4j.useInsecureCertificateGeneration", "true");
        if (!useExternal) {
            SuppressOutput.suppressAll().call((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ServerHolder.setServerBuilderProperty(GraphDatabaseSettings.cypher_hints_error.name(), "true");
                    server = ServerHolder.allocate();
                    ServerHelper.cleanTheDatabase(server);
                    return null;
                }
            });
        }
    }

    @AfterClass
    public static void releaseServer() throws Exception {
        if (!useExternal) {
            try {
                SuppressOutput.suppressAll().call((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ServerHolder.release(server);
                        return null;
                    }
                });
            }
            finally {
                server = null;
            }
        }
    }
}

