/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.neo4j.cypher.CypherException;
import org.neo4j.cypher.InvalidSemanticsException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.graphdb.security.WriteOperationsNotAllowedException;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.rest.transactional.ExecutionResultSerializer;
import org.neo4j.server.rest.transactional.Statement;
import org.neo4j.server.rest.transactional.StatementDeserializer;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.TransactionTerminationHandle;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;
import org.neo4j.server.rest.transactional.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.rest.transactional.error.InternalBeginTransactionError;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.server.rest.web.TransactionUriScheme;

public class TransactionHandle
implements TransactionTerminationHandle {
    private final TransitionalPeriodTransactionMessContainer txManagerFacade;
    private final QueryExecutionEngine engine;
    private final TransactionRegistry registry;
    private final TransactionUriScheme uriScheme;
    private final KernelTransaction.Type type;
    private final AccessMode mode;
    private long customTransactionTimeout;
    private final Log log;
    private final long id;
    private TransitionalTxManagementKernelTransaction context;
    private GraphDatabaseQueryService queryService;

    TransactionHandle(TransitionalPeriodTransactionMessContainer txManagerFacade, QueryExecutionEngine engine, GraphDatabaseQueryService queryService, TransactionRegistry registry, TransactionUriScheme uriScheme, boolean implicitTransaction, AccessMode mode, long customTransactionTimeout, LogProvider logProvider) {
        this.txManagerFacade = txManagerFacade;
        this.engine = engine;
        this.queryService = queryService;
        this.registry = registry;
        this.uriScheme = uriScheme;
        this.type = implicitTransaction ? KernelTransaction.Type.implicit : KernelTransaction.Type.explicit;
        this.mode = mode;
        this.customTransactionTimeout = customTransactionTimeout;
        this.log = logProvider.getLog(this.getClass());
        this.id = registry.begin(this);
    }

    public URI uri() {
        return this.uriScheme.txUri(this.id);
    }

    public boolean isImplicit() {
        return this.type == KernelTransaction.Type.implicit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StatementDeserializer statements, ExecutionResultSerializer output, HttpServletRequest request) {
        LinkedList<Neo4jError> errors = new LinkedList<Neo4jError>();
        try {
            output.transactionCommitUri(this.uriScheme.txCommitUri(this.id));
            this.ensureActiveTransaction();
            this.execute(statements, output, errors, request);
        }
        catch (InternalBeginTransactionError e) {
            errors.add(e.toNeo4jError());
        }
        finally {
            output.errors(errors);
            output.finish();
        }
    }

    @Override
    public boolean terminate() {
        if (this.context != null) {
            this.context.terminate();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(StatementDeserializer statements, ExecutionResultSerializer output, HttpServletRequest request) {
        LinkedList<Neo4jError> errors = new LinkedList<Neo4jError>();
        try {
            try {
                Statement peek = (Statement)statements.peek();
                if (this.isImplicit() && peek == null) {
                    Iterators.addToCollection(statements.errors(), errors);
                } else {
                    this.ensureActiveTransaction();
                    this.executeStatements(statements, output, errors, request);
                    this.closeContextAndCollectErrors(errors);
                }
            }
            finally {
                this.registry.forget(this.id);
            }
        }
        catch (InternalBeginTransactionError e) {
            errors.add(e.toNeo4jError());
        }
        catch (CypherException e) {
            errors.add(new Neo4jError(e.status(), e));
            throw e;
        }
        finally {
            output.errors(errors);
            output.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(ExecutionResultSerializer output) {
        LinkedList<Neo4jError> errors = new LinkedList<Neo4jError>();
        try {
            this.ensureActiveTransaction();
            this.rollback(errors);
        }
        catch (InternalBeginTransactionError e) {
            errors.add(e.toNeo4jError());
        }
        finally {
            output.errors(errors);
            output.finish();
        }
    }

    void forceRollback() throws TransactionFailureException {
        this.context.resumeSinceTransactionsAreStillThreadBound();
        this.context.rollback();
    }

    private void ensureActiveTransaction() throws InternalBeginTransactionError {
        if (this.context == null) {
            try {
                this.context = this.txManagerFacade.newTransaction(this.type, this.mode, this.customTransactionTimeout);
            }
            catch (RuntimeException e) {
                this.log.error("Failed to start transaction.", (Throwable)e);
                throw new InternalBeginTransactionError(e);
            }
        } else {
            this.context.resumeSinceTransactionsAreStillThreadBound();
        }
    }

    private void execute(StatementDeserializer statements, ExecutionResultSerializer output, List<Neo4jError> errors, HttpServletRequest request) {
        this.executeStatements(statements, output, errors, request);
        if (Neo4jError.shouldRollBackOn(errors)) {
            this.rollback(errors);
        } else {
            this.context.suspendSinceTransactionsAreStillThreadBound();
            long lastActiveTimestamp = this.registry.release(this.id, this);
            output.transactionStatus(lastActiveTimestamp);
        }
    }

    private void closeContextAndCollectErrors(List<Neo4jError> errors) {
        block7: {
            if (errors.isEmpty()) {
                try {
                    this.context.commit();
                }
                catch (Exception e) {
                    if (e.getCause() instanceof Status.HasStatus) {
                        errors.add(new Neo4jError(((Status.HasStatus)e.getCause()).status(), e));
                        break block7;
                    }
                    this.log.error("Failed to commit transaction.", (Throwable)e);
                    errors.add(new Neo4jError((Status)Status.Transaction.TransactionCommitFailed, e));
                }
            } else {
                try {
                    this.context.rollback();
                }
                catch (Exception e) {
                    this.log.error("Failed to rollback transaction.", (Throwable)e);
                    errors.add(new Neo4jError((Status)Status.Transaction.TransactionRollbackFailed, e));
                }
            }
        }
    }

    private void rollback(List<Neo4jError> errors) {
        try {
            this.context.rollback();
        }
        catch (Exception e) {
            this.log.error("Failed to rollback transaction.", (Throwable)e);
            errors.add(new Neo4jError((Status)Status.Transaction.TransactionRollbackFailed, e));
        }
        finally {
            this.registry.forget(this.id);
        }
    }

    private void executeStatements(StatementDeserializer statements, ExecutionResultSerializer output, List<Neo4jError> errors, HttpServletRequest request) {
        try {
            boolean hasPrevious = false;
            while (statements.hasNext()) {
                Statement statement = (Statement)statements.next();
                try {
                    boolean hasPeriodicCommit = this.engine.isPeriodicCommit(statement.statement());
                    if ((statements.hasNext() || hasPrevious) && hasPeriodicCommit) {
                        throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("Cannot execute another statement after executing PERIODIC COMMIT statement in the same transaction"));
                    }
                    if (!hasPrevious && hasPeriodicCommit) {
                        this.context.closeTransactionForPeriodicCommit();
                    }
                    hasPrevious = true;
                    TransactionalContext tc = this.txManagerFacade.create(request, this.queryService, this.type, this.mode, statement.statement(), statement.parameters());
                    Result result = this.safelyExecute(statement, hasPeriodicCommit, tc);
                    output.statementResult(result, statement.includeStats(), statement.resultDataContents());
                    output.notifications(result.getNotifications());
                }
                catch (CypherException | AuthorizationViolationException | WriteOperationsNotAllowedException | KernelException e) {
                    errors.add(new Neo4jError(((Status.HasStatus)e).status(), e));
                    break;
                }
                catch (DeadlockDetectedException e) {
                    errors.add(new Neo4jError((Status)Status.Transaction.DeadlockDetected, e));
                }
                catch (IOException e) {
                    errors.add(new Neo4jError((Status)Status.Network.CommunicationError, e));
                    break;
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof Status.HasStatus) {
                        errors.add(new Neo4jError(((Status.HasStatus)cause).status(), cause));
                        break;
                    }
                    errors.add(new Neo4jError((Status)Status.Statement.ExecutionFailed, e));
                    break;
                }
            }
            Iterators.addToCollection(statements.errors(), errors);
        }
        catch (Throwable e) {
            errors.add(new Neo4jError((Status)Status.General.UnknownError, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result safelyExecute(Statement statement, boolean hasPeriodicCommit, TransactionalContext tc) throws QueryExecutionKernelException {
        try {
            Result result = this.engine.executeQuery(statement.statement(), statement.parameters(), tc);
            return result;
        }
        finally {
            if (hasPeriodicCommit) {
                this.context.reopenAfterPeriodicCommit();
            }
        }
    }
}

