/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;

public class TransactionStateChecker {
    private final IsNodeDeletedInCurrentTx nodeCheck;
    private final IsRelationshipDeletedInCurrentTx relCheck;

    TransactionStateChecker(IsNodeDeletedInCurrentTx nodeCheck, IsRelationshipDeletedInCurrentTx relCheck) {
        this.nodeCheck = nodeCheck;
        this.relCheck = relCheck;
    }

    public static TransactionStateChecker create(TransitionalPeriodTransactionMessContainer container) {
        KernelTransaction topLevelTransactionBoundToThisThread = container.getBridge().getTopLevelTransactionBoundToThisThread(true);
        KernelStatement kernelStatement = (KernelStatement)topLevelTransactionBoundToThisThread.acquireStatement();
        return new TransactionStateChecker(nodeId -> kernelStatement.hasTxStateWithChanges() && kernelStatement.txState().nodeIsDeletedInThisTx(nodeId), relId -> kernelStatement.hasTxStateWithChanges() && kernelStatement.txState().relationshipIsDeletedInThisTx(relId));
    }

    public boolean isNodeDeletedInCurrentTx(long id) {
        return this.nodeCheck.test(id);
    }

    public boolean isRelationshipDeletedInCurrentTx(long id) {
        return this.relCheck.test(id);
    }

    @FunctionalInterface
    static interface IsRelationshipDeletedInCurrentTx {
        public boolean test(long var1);
    }

    @FunctionalInterface
    static interface IsNodeDeletedInCurrentTx {
        public boolean test(long var1);
    }
}

