/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.test.server.HTTP;

public class RestRequest {
    private final URI baseUri;
    private static final Client DEFAULT_CLIENT = Client.create();
    private final Client client;
    private MediaType accept = MediaType.APPLICATION_JSON_TYPE;
    private Map<String, String> headers = new HashMap<String, String>();

    public RestRequest(URI baseUri) {
        this(baseUri, null, null);
    }

    public RestRequest(URI baseUri, String username, String password) {
        this.baseUri = this.uriWithoutSlash(baseUri);
        if (username != null) {
            this.client = Client.create();
            this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
        } else {
            this.client = DEFAULT_CLIENT;
        }
    }

    public RestRequest(URI uri, Client client) {
        this.baseUri = this.uriWithoutSlash(uri);
        this.client = client;
    }

    public RestRequest() {
        this(null);
    }

    private URI uriWithoutSlash(URI uri) {
        if (uri == null) {
            return null;
        }
        String uriString = uri.toString();
        return uriString.endsWith("/") ? this.uri(uriString.substring(0, uriString.length() - 1)) : uri;
    }

    private WebResource.Builder builder(String path) {
        return this.builder(path, this.accept);
    }

    private WebResource.Builder builder(String path, MediaType accept) {
        WebResource resource = this.client.resource(this.uri(this.pathOrAbsolute(path)));
        WebResource.Builder builder = resource.accept(new MediaType[]{accept});
        if (!this.headers.isEmpty()) {
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                builder = (WebResource.Builder)builder.header(header.getKey(), (Object)header.getValue());
            }
        }
        return builder;
    }

    private String pathOrAbsolute(String path) {
        if (path.startsWith("http://")) {
            return path;
        }
        return this.baseUri + "/" + path;
    }

    public JaxRsResponse get(String path) {
        return JaxRsResponse.extractFrom(HTTP.sanityCheck((ClientResponse)this.builder(path).get(ClientResponse.class)));
    }

    public JaxRsResponse delete(String path) {
        return JaxRsResponse.extractFrom(HTTP.sanityCheck((ClientResponse)this.builder(path).delete(ClientResponse.class)));
    }

    public JaxRsResponse post(String path, String data) {
        return this.post(path, data, MediaType.APPLICATION_JSON_TYPE);
    }

    public JaxRsResponse post(String path, String data, MediaType mediaType) {
        WebResource.Builder builder = this.builder(path);
        builder = data != null ? (WebResource.Builder)builder.entity((Object)data, mediaType) : (WebResource.Builder)builder.type(mediaType);
        return JaxRsResponse.extractFrom(HTTP.sanityCheck((ClientResponse)builder.post(ClientResponse.class)));
    }

    public JaxRsResponse put(String path, String data) {
        WebResource.Builder builder = this.builder(path);
        if (data != null) {
            builder = (WebResource.Builder)builder.entity((Object)data, MediaType.APPLICATION_JSON_TYPE);
        }
        return new JaxRsResponse(HTTP.sanityCheck((ClientResponse)builder.put(ClientResponse.class)));
    }

    private URI uri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public JaxRsResponse get() {
        return this.get("");
    }

    public JaxRsResponse get(String path, MediaType acceptType) {
        WebResource.Builder builder = this.builder(path, acceptType);
        return JaxRsResponse.extractFrom(HTTP.sanityCheck((ClientResponse)builder.get(ClientResponse.class)));
    }

    public static RestRequest req() {
        return new RestRequest();
    }

    public JaxRsResponse delete(URI location) {
        return this.delete(location.toString());
    }

    public JaxRsResponse put(URI uri, String data) {
        return this.put(uri.toString(), data);
    }

    public RestRequest accept(MediaType accept) {
        this.accept = accept;
        return this;
    }

    public RestRequest header(String header, String value) {
        this.headers.put(header, value);
        return this;
    }
}

