/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.PrettyJSON;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class BatchOperationHeaderIT
extends ExclusiveServerTestBase {
    private NeoServer server;
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Before
    public void cleanTheDatabase() throws IOException {
        this.server = CommunityServerBuilder.server().withThirdPartyJaxRsPackage("org.dummy.web.service", "/dummy").usingDataDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
    }

    @After
    public void stopServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void shouldPassHeaders() throws Exception {
        String jsonData = new PrettyJSON().array().object().key("method").value((Object)"GET").key("to").value((Object)"../../dummy/needs-auth-header").key("body").object().endObject().endObject().endArray().toString();
        JaxRsResponse response = new RestRequest(null, "user", "pass").post("http://localhost:7474/db/data/batch", jsonData);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        List responseData = JsonHelper.jsonToList((String)response.getEntity());
        Map res = (Map)((Map)responseData.get(0)).get("body");
        Assert.assertEquals((Object)"Basic dXNlcjpwYXNz", res.get("Authorization"));
        Assert.assertEquals((Object)"application/json", res.get("Accept"));
        Assert.assertEquals((Object)"application/json", res.get("Content-Type"));
        Assert.assertEquals((Object)"localhost:7474", res.get("Host"));
        Assert.assertEquals((Object)"keep-alive", res.get("Connection"));
    }
}

