/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;

public class GetRelationshipPropertiesIT
extends AbstractRestFunctionalTestBase {
    private static String baseRelationshipUri;
    private static FunctionalTestHelper functionalTestHelper;
    private static GraphDbHelper helper;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(GetRelationshipPropertiesIT.server());
        helper = functionalTestHelper.getGraphDbHelper();
        GetRelationshipPropertiesIT.setupTheDatabase();
    }

    private static void setupTheDatabase() {
        long relationship = helper.createRelationship("LIKES");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", "bar");
        helper.setRelationshipProperties(relationship, map);
        baseRelationshipUri = functionalTestHelper.dataUri() + "relationship/" + relationship + "/properties/";
    }

    @Test
    public void shouldGet200AndContentLengthForProperties() {
        long relId = helper.createRelationship("LIKES");
        helper.setRelationshipProperties(relId, Collections.singletonMap("foo", "bar"));
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.dataUri() + "relationship/" + relId + "/properties");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getHeaders().get((Object)"Content-Length"));
        response.close();
    }

    @Test
    public void shouldGet404ForPropertiesOnNonExistentRelationship() {
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.dataUri() + "relationship/999999/properties");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldBeJSONContentTypeOnPropertiesResponse() {
        long relId = helper.createRelationship("LIKES");
        helper.setRelationshipProperties(relId, Collections.singletonMap("foo", "bar"));
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.dataUri() + "relationship/" + relId + "/properties");
        Assert.assertThat((Object)response.getType().toString(), (Matcher)Matchers.containsString((String)"application/json"));
        response.close();
    }

    private String getPropertyUri(String key) {
        return baseRelationshipUri + key;
    }

    @Test
    public void shouldGet404ForNoProperty() {
        JaxRsResponse response = RestRequest.req().get(this.getPropertyUri("baz"));
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldGet404ForNonExistingRelationship() {
        String uri = functionalTestHelper.dataUri() + "relationship/999999/properties/foo";
        JaxRsResponse response = RestRequest.req().get(uri);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldBeValidJSONOnResponse() throws JsonParseException {
        JaxRsResponse response = RestRequest.req().get(this.getPropertyUri("foo"));
        Assert.assertThat((Object)response.getType().toString(), (Matcher)Matchers.containsString((String)"application/json"));
        Assert.assertNotNull((Object)JsonHelper.createJsonFrom((Object)response.getEntity()));
        response.close();
    }

    @Test
    public void shouldReturnEmptyMapForEmptyProperties() throws Exception {
        String node = HTTP.POST(GetRelationshipPropertiesIT.server().baseUri().resolve("db/data/node").toString()).location();
        String rel = HTTP.POST(node + "/relationships", HTTP.RawPayload.quotedJson("{'to':'" + node + "', 'type':'LOVES'}")).location();
        HTTP.Response res = HTTP.GET(rel + "/properties");
        MatcherAssert.assertThat((Object)res.rawContent(), (Matcher)CoreMatchers.equalTo((Object)"{ }"));
    }
}

