/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.discovery.DiscoveryService;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.test.server.EntityOutputFormat;

public class DiscoveryServiceTest {
    private String baseUri;
    private AdvertisedSocketAddress boltAddress;
    private URI dataUri;
    private URI managementUri;

    @Before
    public void setUp() throws URISyntaxException {
        this.baseUri = "http://www.example.com";
        this.boltAddress = new AdvertisedSocketAddress("www.example.com", 7687);
        this.dataUri = new URI("/data");
        this.managementUri = new URI("/management");
    }

    private Config mockConfig() throws URISyntaxException {
        Config config = Config.defaults();
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(GraphDatabaseSettings.auth_enabled.name(), "false");
        settings.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").type.name(), "BOLT");
        settings.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").enabled.name(), "true");
        settings.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").advertised_address.name(), this.boltAddress.toString());
        settings.put(ServerSettings.management_api_path.name(), this.managementUri.toString());
        settings.put(ServerSettings.rest_api_path.name(), this.dataUri.toString());
        config.augment(settings);
        return config;
    }

    private DiscoveryService testDiscoveryService() throws URISyntaxException {
        Config mockConfig = this.mockConfig();
        return new DiscoveryService(mockConfig, (OutputFormat)new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI(this.baseUri), null));
    }

    @Test
    public void shouldReturnValidJSON() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo("localhost"));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"\"\"")));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"null")));
    }

    private UriInfo uriInfo(String host) {
        URI uri = URI.create(host);
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Mockito.when((Object)uriInfo.getBaseUri()).thenReturn((Object)uri);
        return uriInfo;
    }

    @Test
    public void shouldReturnBoltURI() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo("localhost"));
        String json = new String((byte[])response.getEntity());
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"bolt\" : \"bolt://" + this.boltAddress)));
    }

    @Test
    public void shouldReturnDataURI() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo("localhost"));
        String json = new String((byte[])response.getEntity());
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"data\" : \"" + this.baseUri + this.dataUri + "/\"")));
    }

    @Test
    public void shouldReturnManagementURI() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo("localhost"));
        String json = new String((byte[])response.getEntity());
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"management\" : \"" + this.baseUri + this.managementUri + "/\"")));
    }

    @Test
    public void shouldReturnRedirectToAbsoluteAPIUsingOutputFormat() throws Exception {
        Config mockConfig = (Config)Mockito.mock(Config.class);
        URI browserUri = new URI("/browser/");
        Mockito.when((Object)mockConfig.get(ServerSettings.browser_path)).thenReturn((Object)browserUri);
        String baseUri = "http://www.example.com:5435";
        DiscoveryService ds = new DiscoveryService(mockConfig, (OutputFormat)new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI(baseUri), null));
        Response response = ds.redirectToBrowser();
        Assert.assertThat((Object)response.getMetadata().getFirst((Object)"Location"), (Matcher)Matchers.is((Object)new URI("http://www.example.com:5435/browser/")));
    }
}

