/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.test.TestData;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class AutoIndexWithNonDefaultConfigurationThroughRESTAPIIT
extends ExclusiveServerTestBase {
    private static CommunityNeoServer server;
    private static FunctionalTestHelper functionalTestHelper;
    @ClassRule
    public static TemporaryFolder staticFolder;
    @Rule
    public TestData<RESTRequestGenerator> gen = TestData.producedThrough(RESTRequestGenerator.PRODUCER);

    @BeforeClass
    public static void allocateServer() throws IOException {
        server = CommunityServerBuilder.server().usingDataDir(staticFolder.getRoot().getAbsolutePath()).withAutoIndexingEnabledForNodes("foo", "bar").build();
        server.start();
        functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
    }

    @Before
    public void cleanTheDatabase() {
        ServerHelper.cleanTheDatabase((NeoServer)server);
    }

    @AfterClass
    public static void stopServer() {
        server.stop();
    }

    @Test
    public void shouldCreateANodeAutoIndexWithGivenFullTextConfiguration() throws Exception {
        String responseBody = ((RESTRequestGenerator)this.gen.get()).expectedStatus(201).payload("{\"name\":\"node_auto_index\", \"config\":{\"type\":\"fulltext\",\"provider\":\"lucene\"}}").post(functionalTestHelper.nodeIndexUri()).entity();
        Assert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"\"type\" : \"fulltext\""));
    }

    @Test
    public void shouldCreateARelationshipAutoIndexWithGivenFullTextConfiguration() throws Exception {
        String responseBody = ((RESTRequestGenerator)this.gen.get()).expectedStatus(201).payload("{\"name\":\"relationship_auto_index\", \"config\":{\"type\":\"fulltext\",\"provider\":\"lucene\"}}").post(functionalTestHelper.relationshipIndexUri()).entity();
        Assert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"\"type\" : \"fulltext\""));
    }

    static {
        staticFolder = new TemporaryFolder();
    }
}

