/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.paging;

import java.util.regex.Pattern;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class HexMatcher
extends TypeSafeMatcher<String> {
    private static final Pattern pattern = Pattern.compile("[a-fA-F0-9]*");
    private String candidate;

    private HexMatcher() {
    }

    public void describeTo(Description description) {
        description.appendText(String.format("[%s] is not a pure hexadecimal string", this.candidate));
    }

    public boolean matchesSafely(String candidate) {
        this.candidate = candidate;
        return pattern.matcher(candidate).matches();
    }

    @Factory
    public static Matcher<String> containsOnlyHex() {
        return new HexMatcher();
    }
}

