/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.util.FeaturesAndProperties;
import com.sun.jersey.server.impl.inject.ServerInjectableProviderFactory;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.ExceptionMapperContext;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.monitoring.DispatchingListener;
import com.sun.jersey.spi.monitoring.RequestListener;
import com.sun.jersey.spi.monitoring.ResponseListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.ext.Providers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.web.XForwardFilter;

public class XForwardFilterTest {
    private static final String X_FORWARD_HOST_HEADER_KEY = "X-Forwarded-Host";
    private static final String X_FORWARD_PROTO_HEADER_KEY = "X-Forwarded-Proto";
    private static final WebApplication WEB_APPLICATION = new WebApplication(){

        public boolean isInitiated() {
            return false;
        }

        public void initiate(ResourceConfig resourceConfig) throws IllegalArgumentException, ContainerException {
        }

        public void initiate(ResourceConfig resourceConfig, IoCComponentProviderFactory ioCComponentProviderFactory) throws IllegalArgumentException, ContainerException {
        }

        public WebApplication clone() {
            return null;
        }

        public FeaturesAndProperties getFeaturesAndProperties() {
            return null;
        }

        public Providers getProviders() {
            return null;
        }

        public ResourceContext getResourceContext() {
            return null;
        }

        public MessageBodyWorkers getMessageBodyWorkers() {
            return null;
        }

        public ExceptionMapperContext getExceptionMapperContext() {
            return null;
        }

        public HttpContext getThreadLocalHttpContext() {
            return null;
        }

        public ServerInjectableProviderFactory getServerInjectableProviderFactory() {
            return null;
        }

        public RequestListener getRequestListener() {
            return null;
        }

        public DispatchingListener getDispatchingListener() {
            return null;
        }

        public ResponseListener getResponseListener() {
            return null;
        }

        public void handleRequest(ContainerRequest containerRequest, ContainerResponseWriter containerResponseWriter) throws IOException {
        }

        public void handleRequest(ContainerRequest containerRequest, ContainerResponse containerResponse) throws IOException {
        }

        public void destroy() {
        }

        public boolean isTracingEnabled() {
            return false;
        }

        public void trace(String s) {
        }
    };
    private static final InputStream INPUT_STREAM = new InputStream(){

        @Override
        public int read() throws IOException {
            return 0;
        }
    };

    @Test
    public void shouldSetTheBaseUriToTheSameValueAsTheXForwardHostHeader() throws Exception {
        String xForwardHostAndPort = "jimwebber.org:1234";
        XForwardFilter filter = new XForwardFilter();
        InBoundHeaders headers = new InBoundHeaders();
        headers.add(X_FORWARD_HOST_HEADER_KEY, (Object)"jimwebber.org:1234");
        ContainerRequest request = new ContainerRequest(WEB_APPLICATION, "GET", URI.create("http://iansrobinson.com"), URI.create("http://iansrobinson.com/foo/bar"), headers, INPUT_STREAM);
        ContainerRequest result = filter.filter(request);
        Assert.assertThat((Object)result.getBaseUri().toString(), (Matcher)CoreMatchers.containsString((String)"jimwebber.org:1234"));
    }

    @Test
    public void shouldSetTheRequestUriToTheSameValueAsTheXForwardHostHeader() throws Exception {
        String xForwardHostAndPort = "jimwebber.org:1234";
        XForwardFilter filter = new XForwardFilter();
        InBoundHeaders headers = new InBoundHeaders();
        headers.add(X_FORWARD_HOST_HEADER_KEY, (Object)"jimwebber.org:1234");
        ContainerRequest request = new ContainerRequest(WEB_APPLICATION, "GET", URI.create("http://iansrobinson.com"), URI.create("http://iansrobinson.com/foo/bar"), headers, INPUT_STREAM);
        ContainerRequest result = filter.filter(request);
        Assert.assertTrue((boolean)result.getRequestUri().toString().startsWith("http://jimwebber.org:1234"));
    }

    @Test
    public void shouldSetTheBaseUriToTheSameProtocolAsTheXForwardProtoHeader() throws Exception {
        String theProtocol = "https";
        XForwardFilter filter = new XForwardFilter();
        InBoundHeaders headers = new InBoundHeaders();
        headers.add(X_FORWARD_PROTO_HEADER_KEY, (Object)"https");
        ContainerRequest request = new ContainerRequest(WEB_APPLICATION, "GET", URI.create("http://jimwebber.org:1234"), URI.create("http://jimwebber.org:1234/foo/bar"), headers, INPUT_STREAM);
        ContainerRequest result = filter.filter(request);
        Assert.assertThat((Object)result.getBaseUri().getScheme(), (Matcher)CoreMatchers.containsString((String)"https"));
    }

    @Test
    public void shouldSetTheRequestUriToTheSameProtocolAsTheXForwardProtoHeader() throws Exception {
        String theProtocol = "https";
        XForwardFilter filter = new XForwardFilter();
        InBoundHeaders headers = new InBoundHeaders();
        headers.add(X_FORWARD_PROTO_HEADER_KEY, (Object)"https");
        ContainerRequest request = new ContainerRequest(WEB_APPLICATION, "GET", URI.create("http://jimwebber.org:1234"), URI.create("http://jimwebber.org:1234/foo/bar"), headers, INPUT_STREAM);
        ContainerRequest result = filter.filter(request);
        Assert.assertThat((Object)result.getBaseUri().getScheme(), (Matcher)CoreMatchers.containsString((String)"https"));
    }
}

