/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.net.URI;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.plugins.ConfigAdapter;

public class ConfigAdapterTest {
    @Test
    public void shouldGetDefaultPropertyByKey() throws Exception {
        Config config = new Config(new HashMap(), new Class[]{ServerSettings.class});
        ConfigAdapter wrappingConfiguration = new ConfigAdapter(config);
        Object propertyValue = wrappingConfiguration.getProperty(ServerSettings.rest_api_path.name());
        Assert.assertEquals((Object)new URI(ServerSettings.rest_api_path.getDefaultValue()), (Object)propertyValue);
    }

    @Test
    public void shouldGetPropertyInRightFormat() throws Exception {
        Config config = new Config(new HashMap(), new Class[]{ServerSettings.class});
        ConfigAdapter wrappingConfiguration = new ConfigAdapter(config);
        wrappingConfiguration.setProperty(ServerSettings.rest_api_path.name(), (Object)"http://localhost:7474///db///data///");
        Object dataPath = wrappingConfiguration.getProperty(ServerSettings.rest_api_path.name());
        Assert.assertEquals((Object)new URI(ServerSettings.rest_api_path.getDefaultValue()), (Object)dataPath);
    }

    @Test
    public void shouldContainAllKeysOfPropertiesWithDefaultOrUserDefinedValues() throws Exception {
        Config config = new Config(new HashMap(), new Class[]{ServerSettings.class});
        ConfigAdapter wrappingConfiguration = new ConfigAdapter(config);
        Assert.assertTrue((boolean)wrappingConfiguration.getKeys().hasNext());
    }

    @Test
    public void shouldAbleToAccessRegisteredPropertyByName() {
        Config config = new Config(new HashMap(), new Class[]{ServerSettings.class});
        ConfigAdapter wrappingConfiguration = new ConfigAdapter(config);
        Assert.assertEquals((Object)60000L, (Object)wrappingConfiguration.getProperty(ServerSettings.transaction_idle_timeout.name()));
    }

    @Test
    public void shouldAbleToAccessNonRegisteredPropertyByName() {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{ServerSettings.transaction_idle_timeout.name(), "600"}));
        ConfigAdapter wrappingConfiguration = new ConfigAdapter(config);
        Assert.assertEquals((Object)"600", (Object)wrappingConfiguration.getProperty(ServerSettings.transaction_idle_timeout.name()));
    }
}

