/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.server.database.Database;

public class GraphDbHelper {
    private final Database database;

    public GraphDbHelper(Database database) {
        this.database = database;
    }

    /*
     * Exception decompiling
     */
    public int getNumberOfNodes() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int getNumberOfRelationships() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Map<String, Object> getNodeProperties(long nodeId) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.read());){
            Node node = this.database.getGraph().getNodeById(nodeId);
            Map allProperties = node.getAllProperties();
            tx.success();
            Map map = allProperties;
            return map;
        }
    }

    public void setNodeProperties(long nodeId, Map<String, Object> properties) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.write());){
            Node node = this.database.getGraph().getNodeById(nodeId);
            for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
                node.setProperty(propertyEntry.getKey(), propertyEntry.getValue());
            }
            tx.success();
        }
    }

    public long createNode(Label ... labels) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.write());){
            Node node = this.database.getGraph().createNode(labels);
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    public long createNode(Map<String, Object> properties, Label ... labels) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.write());){
            Node node = this.database.getGraph().createNode(labels);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                node.setProperty(entry.getKey(), entry.getValue());
            }
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    public void deleteNode(long id) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.write());){
            Node node = this.database.getGraph().getNodeById(id);
            node.delete();
            tx.success();
        }
    }

    public long createRelationship(String type, long startNodeId, long endNodeId) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.write());){
            Node startNode = this.database.getGraph().getNodeById(startNodeId);
            Node endNode = this.database.getGraph().getNodeById(endNodeId);
            Relationship relationship = startNode.createRelationshipTo(endNode, RelationshipType.withName((String)type));
            tx.success();
            long l = relationship.getId();
            return l;
        }
    }

    public long createRelationship(String type) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.write());){
            Node startNode = this.database.getGraph().createNode();
            Node endNode = this.database.getGraph().createNode();
            Relationship relationship = startNode.createRelationshipTo(endNode, RelationshipType.withName((String)type));
            tx.success();
            long l = relationship.getId();
            return l;
        }
    }

    public void setRelationshipProperties(long relationshipId, Map<String, Object> properties) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.write());){
            Relationship relationship = this.database.getGraph().getRelationshipById(relationshipId);
            for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
                relationship.setProperty(propertyEntry.getKey(), propertyEntry.getValue());
            }
            tx.success();
        }
    }

    public Map<String, Object> getRelationshipProperties(long relationshipId) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.read());){
            Relationship relationship = this.database.getGraph().getRelationshipById(relationshipId);
            Map allProperties = relationship.getAllProperties();
            tx.success();
            Map map = allProperties;
            return map;
        }
    }

    public Relationship getRelationship(long relationshipId) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.read());){
            Relationship relationship = this.database.getGraph().getRelationshipById(relationshipId);
            tx.success();
            Relationship relationship2 = relationship;
            return relationship2;
        }
    }

    public void addNodeToIndex(String indexName, String key, Object value, long id) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);){
            this.database.getGraph().index().forNodes(indexName).add((PropertyContainer)this.database.getGraph().getNodeById(id), key, value);
            tx.success();
        }
    }

    public Collection<Long> queryIndexedNodes(String indexName, String key, Object value) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.write());){
            ArrayList<Long> result = new ArrayList<Long>();
            for (Node node : this.database.getGraph().index().forNodes(indexName).query(key, value)) {
                result.add(node.getId());
            }
            tx.success();
            Object object = result;
            return object;
        }
    }

    public Collection<Long> getIndexedNodes(String indexName, String key, Object value) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.write());){
            ArrayList<Long> result = new ArrayList<Long>();
            for (Node node : this.database.getGraph().index().forNodes(indexName).get(key, value)) {
                result.add(node.getId());
            }
            tx.success();
            Object object = result;
            return object;
        }
    }

    public Collection<Long> getIndexedRelationships(String indexName, String key, Object value) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.write());){
            ArrayList<Long> result = new ArrayList<Long>();
            for (Relationship relationship : this.database.getGraph().index().forRelationships(indexName).get(key, value)) {
                result.add(relationship.getId());
            }
            tx.success();
            Object object = result;
            return object;
        }
    }

    public void addRelationshipToIndex(String indexName, String key, String value, long relationshipId) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);){
            RelationshipIndex index = this.database.getGraph().index().forRelationships(indexName);
            index.add((PropertyContainer)this.database.getGraph().getRelationshipById(relationshipId), key, (Object)value);
            tx.success();
        }
    }

    public String[] getNodeIndexes() {
        try (InternalTransaction transaction = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.read());){
            String[] stringArray = this.database.getGraph().index().nodeIndexNames();
            return stringArray;
        }
    }

    public Index<Node> createNodeFullTextIndex(String named) {
        try (InternalTransaction transaction = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);){
            Index index = this.database.getGraph().index().forNodes(named, MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext"}));
            transaction.success();
            Index index2 = index;
            return index2;
        }
    }

    public Index<Node> createNodeIndex(String named) {
        try (InternalTransaction transaction = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);){
            Index nodeIndex = this.database.getGraph().index().forNodes(named);
            transaction.success();
            Index index = nodeIndex;
            return index;
        }
    }

    public String[] getRelationshipIndexes() {
        try (InternalTransaction transaction = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.read());){
            String[] stringArray = this.database.getGraph().index().relationshipIndexNames();
            return stringArray;
        }
    }

    public long getFirstNode() {
        Throwable throwable = null;
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.write());){
            Node referenceNode = this.database.getGraph().getNodeById(0L);
            tx.success();
            long l = referenceNode.getId();
            return l;
        }
        catch (NotFoundException e) {
            Node newNode = this.database.getGraph().createNode();
            tx.success();
            long l = newNode.getId();
            return l;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public Index<Relationship> createRelationshipIndex(String named) {
        try (InternalTransaction transaction = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);){
            RelationshipIndex relationshipIndex = this.database.getGraph().index().forRelationships(named);
            transaction.success();
            RelationshipIndex relationshipIndex2 = relationshipIndex;
            return relationshipIndex2;
        }
    }

    public Iterable<String> getNodeLabels(long node) {
        return new IterableWrapper<String, Label>(this.database.getGraph().getNodeById(node).getLabels()){

            protected String underlyingObjectToObject(Label object) {
                return object.name();
            }
        };
    }

    public void addLabelToNode(long node, String labelName) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.write());){
            this.database.getGraph().getNodeById(node).addLabel(Label.label((String)labelName));
            tx.success();
        }
    }

    public Iterable<IndexDefinition> getSchemaIndexes(String labelName) {
        return this.database.getGraph().schema().getIndexes(Label.label((String)labelName));
    }

    public IndexDefinition createSchemaIndex(String labelName, String propertyKey) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);){
            IndexDefinition index = this.database.getGraph().schema().indexFor(Label.label((String)labelName)).on(propertyKey).create();
            tx.success();
            IndexDefinition indexDefinition = index;
            return indexDefinition;
        }
    }

    public Iterable<ConstraintDefinition> getPropertyUniquenessConstraints(String labelName, String propertyKey) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.read());){
            Iterable definitions = Iterables.filter(item -> {
                if (item.isConstraintType(ConstraintType.UNIQUENESS)) {
                    Iterable keys = item.getPropertyKeys();
                    return ((String)Iterables.single((Iterable)keys)).equals(propertyKey);
                }
                return false;
            }, (Iterable)this.database.getGraph().schema().getConstraints(Label.label((String)labelName)));
            tx.success();
            Iterable iterable = definitions;
            return iterable;
        }
    }

    public ConstraintDefinition createPropertyUniquenessConstraint(String labelName, List<String> propertyKeys) {
        try (InternalTransaction tx = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);){
            ConstraintCreator creator = this.database.getGraph().schema().constraintFor(Label.label((String)labelName));
            for (String propertyKey : propertyKeys) {
                creator = creator.assertPropertyIsUnique(propertyKey);
            }
            ConstraintDefinition result = creator.create();
            tx.success();
            ConstraintDefinition constraintDefinition = result;
            return constraintDefinition;
        }
    }

    public long getLabelCount(long nodeId) {
        try (InternalTransaction transaction = this.database.getGraph().beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.read());){
            long l = Iterables.count((Iterable)this.database.getGraph().getNodeById(nodeId).getLabels());
            return l;
        }
    }
}

