/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.io.IOException;
import java.net.BindException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.function.Consumer;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.MovedContextHandler;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.neo4j.bolt.security.ssl.KeyStoreInformation;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.PortBindException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.database.InjectableProvider;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.security.ssl.SslSocketConnectorFactory;
import org.neo4j.server.web.HttpConnectorFactory;
import org.neo4j.server.web.JaxRsServletHolderFactory;
import org.neo4j.server.web.JettyThreadCalculator;
import org.neo4j.server.web.NeoJettyErrorHandler;
import org.neo4j.server.web.NoCacheHtmlFilter;
import org.neo4j.server.web.WebServer;

public class Jetty9WebServer
implements WebServer {
    private boolean wadlEnabled;
    private Collection<InjectableProvider<?>> defaultInjectables;
    private Consumer<Server> jettyCreatedCallback;
    private RequestLog requestLog;
    public static final ListenSocketAddress DEFAULT_ADDRESS = new ListenSocketAddress("0.0.0.0", 80);
    private Server jetty;
    private HandlerCollection handlers;
    private ListenSocketAddress jettyAddress = DEFAULT_ADDRESS;
    private Optional<ListenSocketAddress> jettyHttpsAddress = Optional.empty();
    private final HashMap<String, String> staticContent = new HashMap();
    private final Map<String, JaxRsServletHolderFactory> jaxRSPackages = new HashMap<String, JaxRsServletHolderFactory>();
    private final Map<String, JaxRsServletHolderFactory> jaxRSClasses = new HashMap<String, JaxRsServletHolderFactory>();
    private final List<FilterDefinition> filters = new ArrayList<FilterDefinition>();
    private int jettyMaxThreads = 1;
    private KeyStoreInformation httpsCertificateInformation = null;
    private final SslSocketConnectorFactory sslSocketFactory;
    private final HttpConnectorFactory connectorFactory;
    private final Log log;

    public Jetty9WebServer(LogProvider logProvider, Config config) {
        this.log = logProvider.getLog(this.getClass());
        this.sslSocketFactory = new SslSocketConnectorFactory(config);
        this.connectorFactory = new HttpConnectorFactory(config);
    }

    @Override
    public void start() throws Exception {
        if (this.jetty == null) {
            JettyThreadCalculator jettyThreadCalculator = new JettyThreadCalculator(this.jettyMaxThreads);
            this.jetty = new Server((ThreadPool)this.createQueuedThreadPool(jettyThreadCalculator));
            this.jetty.addConnector((Connector)this.connectorFactory.createConnector(this.jetty, this.jettyAddress, jettyThreadCalculator));
            this.jettyHttpsAddress.ifPresent(address -> {
                if (this.httpsCertificateInformation == null) {
                    throw new RuntimeException("HTTPS set to enabled, but no HTTPS configuration provided");
                }
                this.jetty.addConnector((Connector)this.sslSocketFactory.createConnector(this.jetty, this.httpsCertificateInformation, (ListenSocketAddress)address, jettyThreadCalculator));
            });
            if (this.jettyCreatedCallback != null) {
                this.jettyCreatedCallback.accept(this.jetty);
            }
        }
        this.handlers = new HandlerList();
        this.jetty.setHandler((Handler)this.handlers);
        this.handlers.addHandler((Handler)new MovedContextHandler());
        this.loadAllMounts();
        if (this.requestLog != null) {
            this.loadRequestLogging();
        }
        this.startJetty();
    }

    private QueuedThreadPool createQueuedThreadPool(JettyThreadCalculator jtc) {
        BlockingArrayQueue queue = new BlockingArrayQueue(jtc.getMinThreads(), jtc.getMinThreads(), jtc.getMaxCapacity());
        return new QueuedThreadPool(jtc.getMaxThreads(), jtc.getMinThreads(), 60000, (BlockingQueue)queue);
    }

    @Override
    public void stop() {
        if (this.jetty != null) {
            try {
                this.jetty.stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                this.jetty.join();
            }
            catch (InterruptedException e) {
                this.log.warn("Interrupted while waiting for Jetty to stop");
            }
            this.jetty = null;
        }
    }

    @Override
    public void setAddress(ListenSocketAddress address) {
        this.jettyAddress = address;
    }

    @Override
    public void setMaxThreads(int maxThreads) {
        this.jettyMaxThreads = maxThreads;
    }

    @Override
    public void addJAXRSPackages(List<String> packageNames, String mountPoint, Collection<Injectable<?>> injectables) {
        mountPoint = this.ensureRelativeUri(mountPoint);
        JaxRsServletHolderFactory factory = this.jaxRSPackages.get(mountPoint = this.trimTrailingSlashToKeepJettyHappy(mountPoint));
        if (factory == null) {
            factory = new JaxRsServletHolderFactory.Packages();
            this.jaxRSPackages.put(mountPoint, factory);
        }
        factory.add(packageNames, injectables);
        this.log.debug("Adding JAXRS packages %s at [%s]", new Object[]{packageNames, mountPoint});
    }

    @Override
    public void addJAXRSClasses(List<String> classNames, String mountPoint, Collection<Injectable<?>> injectables) {
        mountPoint = this.ensureRelativeUri(mountPoint);
        JaxRsServletHolderFactory factory = this.jaxRSClasses.get(mountPoint = this.trimTrailingSlashToKeepJettyHappy(mountPoint));
        if (factory == null) {
            factory = new JaxRsServletHolderFactory.Classes();
            this.jaxRSClasses.put(mountPoint, factory);
        }
        factory.add(classNames, injectables);
        this.log.debug("Adding JAXRS classes %s at [%s]", new Object[]{classNames, mountPoint});
    }

    @Override
    public void setWadlEnabled(boolean wadlEnabled) {
        this.wadlEnabled = wadlEnabled;
    }

    @Override
    public void setDefaultInjectables(Collection<InjectableProvider<?>> defaultInjectables) {
        this.defaultInjectables = defaultInjectables;
    }

    @Override
    public void setJettyCreatedCallback(Consumer<Server> callback) {
        this.jettyCreatedCallback = callback;
    }

    @Override
    public void removeJAXRSPackages(List<String> packageNames, String serverMountPoint) {
        JaxRsServletHolderFactory factory = this.jaxRSPackages.get(serverMountPoint);
        if (factory != null) {
            factory.remove(packageNames);
        }
    }

    @Override
    public void removeJAXRSClasses(List<String> classNames, String serverMountPoint) {
        JaxRsServletHolderFactory factory = this.jaxRSClasses.get(serverMountPoint);
        if (factory != null) {
            factory.remove(classNames);
        }
    }

    @Override
    public void addFilter(Filter filter, String pathSpec) {
        this.filters.add(new FilterDefinition(filter, pathSpec));
    }

    @Override
    public void removeFilter(Filter filter, String pathSpec) {
        Iterator<FilterDefinition> iter = this.filters.iterator();
        while (iter.hasNext()) {
            FilterDefinition current = iter.next();
            if (!current.matches(filter, pathSpec)) continue;
            iter.remove();
        }
    }

    @Override
    public void addStaticContent(String contentLocation, String serverMountPoint) {
        this.staticContent.put(serverMountPoint, contentLocation);
    }

    @Override
    public void removeStaticContent(String contentLocation, String serverMountPoint) {
        this.staticContent.remove(serverMountPoint);
    }

    @Override
    public void invokeDirectly(String targetPath, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.jetty.handle(targetPath, (Request)request, request, response);
    }

    @Override
    public void setRequestLog(RequestLog requestLog) {
        this.requestLog = requestLog;
    }

    @Override
    public void setHttpsAddress(Optional<ListenSocketAddress> address) {
        this.jettyHttpsAddress = address;
    }

    @Override
    public void setHttpsCertificateInformation(KeyStoreInformation config) {
        this.httpsCertificateInformation = config;
    }

    public Server getJetty() {
        return this.jetty;
    }

    protected void startJetty() throws Exception {
        try {
            this.jetty.start();
        }
        catch (BindException e) {
            if (this.jettyHttpsAddress.isPresent()) {
                throw new PortBindException(this.jettyAddress, this.jettyHttpsAddress.get(), e);
            }
            throw new PortBindException(this.jettyAddress, e);
        }
    }

    private void loadAllMounts() throws IOException {
        HashSessionManager sm = new HashSessionManager();
        TreeSet<String> mountpoints = new TreeSet<String>((o1, o2) -> o2.compareTo((String)o1));
        mountpoints.addAll(this.staticContent.keySet());
        mountpoints.addAll(this.jaxRSPackages.keySet());
        mountpoints.addAll(this.jaxRSClasses.keySet());
        for (String contentKey : mountpoints) {
            boolean isStatic = this.staticContent.containsKey(contentKey);
            boolean isJaxrsPackage = this.jaxRSPackages.containsKey(contentKey);
            boolean isJaxrsClass = this.jaxRSClasses.containsKey(contentKey);
            if (this.countSet(isStatic, isJaxrsPackage, isJaxrsClass) > 1) {
                throw new RuntimeException(String.format("content-key '%s' is mapped more than once", contentKey));
            }
            if (isStatic) {
                this.loadStaticContent((SessionManager)sm, contentKey);
                continue;
            }
            if (isJaxrsPackage) {
                this.loadJAXRSPackage((SessionManager)sm, contentKey);
                continue;
            }
            if (isJaxrsClass) {
                this.loadJAXRSClasses((SessionManager)sm, contentKey);
                continue;
            }
            throw new RuntimeException(String.format("content-key '%s' is not mapped", contentKey));
        }
    }

    private int countSet(boolean ... booleans) {
        int count = 0;
        for (boolean bool : booleans) {
            if (!bool) continue;
            ++count;
        }
        return count;
    }

    private void loadRequestLogging() {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog(this.requestLog);
        requestLogHandler.setServer(this.jetty);
        requestLogHandler.setHandler(this.jetty.getHandler());
        this.jetty.setHandler((Handler)requestLogHandler);
    }

    private String trimTrailingSlashToKeepJettyHappy(String mountPoint) {
        if (mountPoint.equals("/")) {
            return mountPoint;
        }
        if (mountPoint.endsWith("/")) {
            mountPoint = mountPoint.substring(0, mountPoint.length() - 1);
        }
        return mountPoint;
    }

    private String ensureRelativeUri(String mountPoint) {
        try {
            URI result = new URI(mountPoint);
            if (result.isAbsolute()) {
                return result.getPath();
            }
            return result.toString();
        }
        catch (URISyntaxException e) {
            this.log.debug("Unable to translate [%s] to a relative URI in ensureRelativeUri(String mountPoint)", new Object[]{mountPoint});
            return mountPoint;
        }
    }

    private void loadStaticContent(SessionManager sm, String mountPoint) {
        String contentLocation = this.staticContent.get(mountPoint);
        try {
            SessionHandler sessionHandler = new SessionHandler(sm);
            sessionHandler.setServer(this.getJetty());
            WebAppContext staticContext = new WebAppContext();
            staticContext.setServer(this.getJetty());
            staticContext.setContextPath(mountPoint);
            staticContext.setSessionHandler(sessionHandler);
            staticContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
            URL resourceLoc = this.getClass().getClassLoader().getResource(contentLocation);
            if (resourceLoc != null) {
                URL url = resourceLoc.toURI().toURL();
                Resource resource = Resource.newResource((URL)url);
                staticContext.setBaseResource(resource);
                this.addFiltersTo((ServletContextHandler)staticContext);
                staticContext.addFilter(new FilterHolder((Filter)new NoCacheHtmlFilter()), "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD));
                this.handlers.addHandler((Handler)staticContext);
            } else {
                this.log.warn("No static content available for Neo Server at %s, management console may not be available.", new Object[]{this.jettyAddress});
            }
        }
        catch (Exception e) {
            this.log.error("Unknown error loading static content", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void loadJAXRSPackage(SessionManager sm, String mountPoint) {
        this.loadJAXRSResource(sm, mountPoint, this.jaxRSPackages.get(mountPoint));
    }

    private void loadJAXRSClasses(SessionManager sm, String mountPoint) {
        this.loadJAXRSResource(sm, mountPoint, this.jaxRSClasses.get(mountPoint));
    }

    private void loadJAXRSResource(SessionManager sm, String mountPoint, JaxRsServletHolderFactory jaxRsServletHolderFactory) {
        SessionHandler sessionHandler = new SessionHandler(sm);
        sessionHandler.setServer(this.getJetty());
        this.log.debug("Mounting servlet at [%s]", new Object[]{mountPoint});
        ServletContextHandler jerseyContext = new ServletContextHandler();
        jerseyContext.setServer(this.getJetty());
        jerseyContext.setErrorHandler((ErrorHandler)new NeoJettyErrorHandler());
        jerseyContext.setContextPath(mountPoint);
        jerseyContext.setSessionHandler(sessionHandler);
        jerseyContext.addServlet(jaxRsServletHolderFactory.create(this.defaultInjectables, this.wadlEnabled), "/*");
        this.addFiltersTo(jerseyContext);
        this.handlers.addHandler((Handler)jerseyContext);
    }

    private void addFiltersTo(ServletContextHandler context) {
        for (FilterDefinition filterDef : this.filters) {
            context.addFilter(new FilterHolder(filterDef.getFilter()), filterDef.getPathSpec(), EnumSet.allOf(DispatcherType.class));
        }
    }

    private static class FilterDefinition {
        private final Filter filter;
        private final String pathSpec;

        public FilterDefinition(Filter filter, String pathSpec) {
            this.filter = filter;
            this.pathSpec = pathSpec;
        }

        public boolean matches(Filter filter, String pathSpec) {
            return filter == this.filter && pathSpec.equals(this.pathSpec);
        }

        public Filter getFilter() {
            return this.filter;
        }

        public String getPathSpec() {
            return this.pathSpec;
        }
    }
}

