/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;

public class ServerSettingsTest {
    @Test
    public void webServerThreadCountDefaultShouldBeDocumented() throws Exception {
        Config config = Config.serverDefaults();
        String documentedDefaultValue = (String)((Optional)config.getDocumentedDefaults().entrySet().stream().filter(c -> ((String)c.getKey()).equals(ServerSettings.webserver_max_threads.name())).findAny().orElseThrow(() -> new RuntimeException("Setting not present!")).getValue()).orElseThrow(() -> new RuntimeException("Default value not present!"));
        Assert.assertEquals((Object)"Number of available processors (max 500).", (Object)documentedDefaultValue);
    }

    @Test
    public void configValuesContainsConnectors() throws Exception {
        Config config = Config.serverDefaults();
        List connectorSettings = config.getConfigValues().entrySet().stream().map(Map.Entry::getKey).filter(c -> c.startsWith("dbms.connector")).filter(c -> c.endsWith(".enabled")).collect(Collectors.toList());
        Assert.assertThat(connectorSettings, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"dbms.connector.http.enabled", "dbms.connector.https.enabled", "dbms.connector.bolt.enabled"}));
    }
}

