/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.neo4j.bolt.BoltKernelExtension;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.DocumentedDefaultValue;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Internal;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;

@Description(value="Settings used by the server configuration")
public class ServerSettings
implements LoadableConfig {
    @Description(value="Maximum request header size")
    @Internal
    public static final Setting<Integer> maximum_request_header_size = Settings.setting((String)"unsupported.dbms.max_http_request_header_size", (Function)Settings.INTEGER, (String)"20480");
    @Description(value="Maximum response header size")
    @Internal
    public static final Setting<Integer> maximum_response_header_size = Settings.setting((String)"unsupported.dbms.max_http_response_header_size", (Function)Settings.INTEGER, (String)"20480");
    @Description(value="Comma-seperated list of custom security rules for Neo4j to use.")
    public static final Setting<List<String>> security_rules = Settings.setting((String)"dbms.security.http_authorization_classes", (Function)Settings.STRING_LIST, (String)"");
    @Description(value="Number of Neo4j worker threads, your OS might enforce a lower limit than the maximum value specified here.")
    @DocumentedDefaultValue(value="Number of available processors (max 500).")
    public static final Setting<Integer> webserver_max_threads = Settings.setting((String)"dbms.threads.worker_count", (Function)Settings.INTEGER, (String)("" + Math.min(Runtime.getRuntime().availableProcessors(), 500)), (BiFunction[])new BiFunction[]{Settings.range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(44738))});
    @Description(value="If execution time limiting is enabled in the database, this configures the maximum request execution time. Please use dbms.transaction.timeout instead.")
    @Internal
    @Deprecated
    public static final Setting<Long> webserver_limit_execution_time = Settings.setting((String)"unsupported.dbms.executiontime_limit.time", (Function)Settings.DURATION, (String)Settings.NO_DEFAULT);
    @Internal
    public static final Setting<List<String>> console_module_engines = Settings.setting((String)"unsupported.dbms.console_module.engines", (Function)Settings.STRING_LIST, (String)"SHELL");
    @Description(value="Comma-separated list of <classname>=<mount point> for unmanaged extensions.")
    public static final Setting<List<ThirdPartyJaxRsPackage>> third_party_packages = Settings.setting((String)"dbms.unmanaged_extension_classes", (Function)new Function<String, List<ThirdPartyJaxRsPackage>>(){

        @Override
        public List<ThirdPartyJaxRsPackage> apply(String value) {
            String[] list = value.split(",");
            ArrayList<ThirdPartyJaxRsPackage> result = new ArrayList<ThirdPartyJaxRsPackage>();
            for (String item : list) {
                if ((item = item.trim()).equals("")) continue;
                result.add(this.createThirdPartyJaxRsPackage(item));
            }
            return result;
        }

        public String toString() {
            return "a comma-seperated list of <classname>=<mount point> strings";
        }

        private ThirdPartyJaxRsPackage createThirdPartyJaxRsPackage(String packageAndMoutpoint) {
            String[] parts = packageAndMoutpoint.split("=");
            if (parts.length != 2) {
                throw new IllegalArgumentException("config for " + third_party_packages.name() + " is wrong: " + packageAndMoutpoint);
            }
            String pkg = parts[0];
            String mountPoint = parts[1];
            return new ThirdPartyJaxRsPackage(pkg, mountPoint);
        }
    }, (String)"");
    @Description(value="Directory for storing certificates to be used by Neo4j for TLS connections. Certificate files must be named _neo4j.cert_ and _neo4j.key_")
    public static final Setting<File> certificates_directory = BoltKernelExtension.Settings.certificates_directory;
    @Internal
    @Description(value="Path to the X.509 public certificate to be used by Neo4j for TLS connections")
    public static final Setting<File> tls_certificate_file = BoltKernelExtension.Settings.tls_certificate_file;
    @Internal
    @Description(value="Path to the X.509 private key to be used by Neo4j for TLS connections")
    public static final Setting<File> tls_key_file = BoltKernelExtension.Settings.tls_key_file;
    @Description(value="Enable HTTP request logging.")
    public static final Setting<Boolean> http_logging_enabled = Settings.setting((String)"dbms.logs.http.enabled", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="Number of HTTP logs to keep.")
    public static final Setting<Integer> http_logging_rotation_keep_number = Settings.setting((String)"dbms.logs.http.rotation.keep_number", (Function)Settings.INTEGER, (String)"5");
    @Description(value="Size of each HTTP log that is kept.")
    public static final Setting<Long> http_logging_rotation_size = Settings.setting((String)"dbms.logs.http.rotation.size", (Function)Settings.BYTES, (String)"20m", (BiFunction[])new BiFunction[]{Settings.min((Comparable)Long.valueOf(0L)), Settings.max((Comparable)Long.valueOf(Long.MAX_VALUE))});
    @Description(value="Enable GC Logging")
    public static final Setting<Boolean> gc_logging_enabled = Settings.setting((String)"dbms.logs.gc.enabled", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="GC Logging Options")
    public static final Setting<String> gc_logging_options = Settings.setting((String)"dbms.logs.gc.options", (Function)Settings.STRING, (String)"-XX:+PrintGCDetails -XX:+PrintGCDateStamps -XX:+PrintGCApplicationStoppedTime -XX:+PrintPromotionFailure -XX:+PrintTenuringDistribution");
    @Description(value="Number of GC logs to keep.")
    public static final Setting<Integer> gc_logging_rotation_keep_number = Settings.setting((String)"dbms.logs.gc.rotation.keep_number", (Function)Settings.INTEGER, (String)"5");
    @Description(value="Size of each GC log that is kept.")
    public static final Setting<Long> gc_logging_rotation_size = Settings.setting((String)"dbms.logs.gc.rotation.size", (Function)Settings.BYTES, (String)"20m", (BiFunction[])new BiFunction[]{Settings.min((Comparable)Long.valueOf(0L)), Settings.max((Comparable)Long.valueOf(Long.MAX_VALUE))});
    @Description(value="Path of the run directory. This directory holds Neo4j's runtime state, such as a pidfile when it is running in the background. The pidfile is created when starting neo4j and removed when stopping it. It may be placed on an in-memory filesystem such as tmpfs.")
    public static final Setting<File> run_directory = Settings.pathSetting((String)"dbms.directories.run", (String)"run");
    @Description(value="Path of the lib directory")
    public static final Setting<File> lib_directory = Settings.pathSetting((String)"dbms.directories.lib", (String)"lib");
    @Description(value="Timeout for idle transactions in the REST endpoint.")
    public static final Setting<Long> transaction_idle_timeout = Settings.setting((String)"dbms.rest.transaction.idle_timeout", (Function)Settings.DURATION, (String)"60s");
    @Internal
    public static final Setting<URI> rest_api_path = Settings.setting((String)"unsupported.dbms.uris.rest", (Function)Settings.NORMALIZED_RELATIVE_URI, (String)"/db/data");
    @Internal
    public static final Setting<URI> management_api_path = Settings.setting((String)"unsupported.dbms.uris.management", (Function)Settings.NORMALIZED_RELATIVE_URI, (String)"/db/manage");
    @Internal
    public static final Setting<URI> browser_path = Settings.setting((String)"unsupported.dbms.uris.browser", (Function)Settings.URI, (String)"/browser/");
    @Internal
    public static final Setting<Boolean> script_sandboxing_enabled = Settings.setting((String)"unsupported.dbms.security.script_sandboxing_enabled", (Function)Settings.BOOLEAN, (String)"true");
    @Internal
    public static final Setting<Boolean> wadl_enabled = Settings.setting((String)"unsupported.dbms.wadl_generation_enabled", (Function)Settings.BOOLEAN, (String)"false");
    @Internal
    public static final Setting<Boolean> console_module_enabled = Settings.setting((String)"unsupported.dbms.console_module.enabled", (Function)Settings.BOOLEAN, (String)"true");
}

