/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.NeoServer;
import org.neo4j.server.ServerBootstrapper;
import org.neo4j.test.rule.SuppressOutput;

public class ServerBootstrapperTest {
    @Rule
    public final SuppressOutput suppress = SuppressOutput.suppress((SuppressOutput.Suppressible[])new SuppressOutput.Suppressible[]{SuppressOutput.System.out});

    @Test
    public void shouldNotThrowNullPointerExceptionIfConfigurationValidationFails() throws Exception {
        ServerBootstrapper serverBootstrapper = new ServerBootstrapper(){

            protected NeoServer createNeoServer(Config config, GraphDatabaseDependencies dependencies, LogProvider userLogProvider) {
                return (NeoServer)Mockito.mock(NeoServer.class);
            }

            @Nonnull
            protected Collection<ConfigurationValidator> configurationValidators() {
                return Collections.emptyList();
            }
        };
        File dir = Files.createTempDirectory("test-server-bootstrapper", new FileAttribute[0]).toFile();
        dir.deleteOnExit();
        serverBootstrapper.start(dir, Optional.empty(), new Pair[0]);
        Assert.assertThat((Object)this.suppress.getOutputVoice().lines(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
    }
}

