/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import java.net.URI;
import javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.server.rest.security.NoAccessToDatabaseSecurityRule;
import org.neo4j.server.rest.security.PermanentlyFailingSecurityRule;
import org.neo4j.server.rest.security.PermanentlyFailingSecurityRuleWithComplexWildcardPath;
import org.neo4j.server.rest.security.PermanentlyFailingSecurityRuleWithWildcardPath;
import org.neo4j.server.rest.security.PermanentlyForbiddenSecurityRule;
import org.neo4j.server.rest.security.PermanentlyPassingSecurityRule;
import org.neo4j.test.TestData;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class SecurityRulesIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;
    private FunctionalTestHelper functionalTestHelper;
    @Rule
    public TestData<RESTRequestGenerator> gen = TestData.producedThrough(RESTRequestGenerator.PRODUCER);

    @After
    public void stopServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    @TestData.Title(value="Enforcing Server Authorization Rules")
    @Documented(value="In this example, a (dummy) failing security rule is registered to deny\naccess to all URIs to the server by listing the rules class in\n'neo4j.conf':\n\n@@config\n\nwith the rule source code of:\n\n@@failingRule\n\nWith this rule registered, any access to the server will be\ndenied. In a production-quality implementation the rule\nwill likely lookup credentials/claims in a 3rd-party\ndirectory service (e.g. LDAP) or in a local database of\nauthorized users.")
    public void should401WithBasicChallengeWhenASecurityRuleFails() throws Exception {
        this.server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withSecurityRules(PermanentlyFailingSecurityRule.class.getCanonicalName()).usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        this.functionalTestHelper = new FunctionalTestHelper((NeoServer)this.server);
        JaxRsResponse response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(401).expectedHeader("WWW-Authenticate").post(this.functionalTestHelper.nodeUri()).response();
        Assert.assertThat((Object)response.getHeaders().getFirst((Object)"WWW-Authenticate"), (Matcher)Matchers.containsString((String)"Basic realm=\"WallyWorld\""));
    }

    @Test
    public void should401WithBasicChallengeIfAnyOneOfTheRulesFails() throws Exception {
        this.server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withSecurityRules(PermanentlyFailingSecurityRule.class.getCanonicalName(), PermanentlyPassingSecurityRule.class.getCanonicalName()).usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        this.functionalTestHelper = new FunctionalTestHelper((NeoServer)this.server);
        JaxRsResponse response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(401).expectedHeader("WWW-Authenticate").post(this.functionalTestHelper.nodeUri()).response();
        Assert.assertThat((Object)response.getHeaders().getFirst((Object)"WWW-Authenticate"), (Matcher)Matchers.containsString((String)"Basic realm=\"WallyWorld\""));
    }

    @Test
    public void shouldInvokeAllSecurityRules() throws Exception {
        this.server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withSecurityRules(NoAccessToDatabaseSecurityRule.class.getCanonicalName()).usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        this.functionalTestHelper = new FunctionalTestHelper((NeoServer)this.server);
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(401).get(this.functionalTestHelper.dataUri()).response();
        Assert.assertTrue((boolean)NoAccessToDatabaseSecurityRule.wasInvoked());
    }

    @Test
    public void shouldRespondWith201IfAllTheRulesPassWhenCreatingANode() throws Exception {
        this.server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withSecurityRules(PermanentlyPassingSecurityRule.class.getCanonicalName()).usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        this.functionalTestHelper = new FunctionalTestHelper((NeoServer)this.server);
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(201).expectedHeader("Location").post(this.functionalTestHelper.nodeUri()).response();
    }

    @Test
    @TestData.Title(value="Using Wildcards to Target Security Rules")
    @Documented(value="In this example, a security rule is registered to deny\naccess to all URIs to the server by listing the rule(s) class(es) in\n'neo4j.conf'.\nIn this case, the rule is registered\nusing a wildcard URI path (where `*` characters can be used to signify\nany part of the path). For example `/users*` means the rule\nwill be bound to any resources under the `/users` root path. Similarly\n`/users*type*` will bind the rule to resources matching\nURIs like `/users/fred/type/premium`.\n\n@@config\n\nwith the rule source code of:\n\n@@failingRuleWithWildcardPath\n\nWith this rule registered, any access to URIs under /protected/ will be\ndenied by the server. Using wildcards allows flexible targeting of security rules to\narbitrary parts of the server's API, including any unmanaged extensions or managed\nplugins that have been registered.")
    public void aSimpleWildcardUriPathShould401OnAccessToProtectedSubPath() throws Exception {
        String mountPoint = "/protected/tree/starts/here/dummy";
        this.server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withThirdPartyJaxRsPackage("org.dummy.web.service", mountPoint).withSecurityRules(PermanentlyFailingSecurityRuleWithWildcardPath.class.getCanonicalName()).usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        this.functionalTestHelper = new FunctionalTestHelper((NeoServer)this.server);
        JaxRsResponse clientResponse = ((RESTRequestGenerator)this.gen.get()).expectedStatus(401).expectedType(MediaType.APPLICATION_JSON_TYPE).expectedHeader("WWW-Authenticate").get(this.trimTrailingSlash(this.functionalTestHelper.baseUri()) + mountPoint + "/more/stuff").response();
        Assert.assertEquals((long)401L, (long)clientResponse.getStatus());
    }

    @Test
    @TestData.Title(value="Using Complex Wildcards to Target Security Rules")
    @Documented(value="In this example, a security rule is registered to deny\naccess to all URIs matching a complex pattern.\nThe config looks like this:\n\n@@config\n\nwith the rule source code of:\n\n@@failingRuleWithComplexWildcardPath")
    public void aComplexWildcardUriPathShould401OnAccessToProtectedSubPath() throws Exception {
        String mountPoint = "/protected/wildcard_replacement/x/y/z/something/else/more_wildcard_replacement/a/b/c/final/bit";
        this.server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withThirdPartyJaxRsPackage("org.dummy.web.service", mountPoint).withSecurityRules(PermanentlyFailingSecurityRuleWithComplexWildcardPath.class.getCanonicalName()).usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        this.functionalTestHelper = new FunctionalTestHelper((NeoServer)this.server);
        JaxRsResponse clientResponse = ((RESTRequestGenerator)this.gen.get()).expectedStatus(401).expectedType(MediaType.APPLICATION_JSON_TYPE).expectedHeader("WWW-Authenticate").get(this.trimTrailingSlash(this.functionalTestHelper.baseUri()) + mountPoint + "/more/stuff").response();
        Assert.assertEquals((long)401L, (long)clientResponse.getStatus());
    }

    @Test
    public void should403WhenAuthenticatedButForbidden() throws Exception {
        this.server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withSecurityRules(PermanentlyForbiddenSecurityRule.class.getCanonicalName(), PermanentlyPassingSecurityRule.class.getCanonicalName()).usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        this.functionalTestHelper = new FunctionalTestHelper((NeoServer)this.server);
        JaxRsResponse clientResponse = ((RESTRequestGenerator)this.gen.get()).expectedStatus(403).expectedType(MediaType.APPLICATION_JSON_TYPE).get(this.trimTrailingSlash(this.functionalTestHelper.baseUri())).response();
        Assert.assertEquals((long)403L, (long)clientResponse.getStatus());
    }

    private String trimTrailingSlash(URI uri) {
        String result = uri.toString();
        if (result.endsWith("/")) {
            return result.substring(0, result.length() - 1);
        }
        return result;
    }
}

