/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class WebServerDirectoryListingTest
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;

    @Test
    public void shouldDisallowDirectoryListings() throws Exception {
        this.server = CommunityServerBuilder.server().build();
        this.server.start();
        HTTP.Response okResource = HTTP.GET(this.server.baseUri().resolve("/browser/index.html").toString());
        HTTP.Response illegalResource = HTTP.GET(this.server.baseUri().resolve("/browser/assets/").toString());
        Assert.assertEquals((long)200L, (long)okResource.status());
        Assert.assertEquals((long)403L, (long)illegalResource.status());
    }

    @After
    public void cleanup() {
        if (this.server != null) {
            this.server.stop();
        }
    }
}

