/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.web.JettyThreadCalculator;

public class JettyThreadCalculatorTest {
    @Test
    public void shouldHaveCorrectAmountOfThreads() {
        JettyThreadCalculator jtc = new JettyThreadCalculator(1);
        Assert.assertEquals((String)"Wrong acceptor value for 1 core", (long)1L, (long)jtc.getAcceptors());
        Assert.assertEquals((String)"Wrong selector value for 1 core", (long)1L, (long)jtc.getSelectors());
        Assert.assertEquals((String)"Wrong maxThreads value for 1 core", (long)12L, (long)jtc.getMaxThreads());
        Assert.assertEquals((String)"Wrong minThreads value for 1 core", (long)6L, (long)jtc.getMinThreads());
        Assert.assertEquals((String)"Wrong capacity value for 1 core", (long)480000L, (long)jtc.getMaxCapacity());
        jtc = new JettyThreadCalculator(4);
        Assert.assertEquals((String)"Wrong acceptor value for 4 cores", (long)1L, (long)jtc.getAcceptors());
        Assert.assertEquals((String)"Wrong selector value for 4 cores", (long)2L, (long)jtc.getSelectors());
        Assert.assertEquals((String)"Wrong maxThreads value for 4 cores", (long)14L, (long)jtc.getMaxThreads());
        Assert.assertEquals((String)"Wrong minThreads value for 4 cores", (long)8L, (long)jtc.getMinThreads());
        Assert.assertEquals((String)"Wrong capacity value for 4 cores", (long)480000L, (long)jtc.getMaxCapacity());
        jtc = new JettyThreadCalculator(16);
        Assert.assertEquals((String)"Wrong acceptor value for 16 cores", (long)2L, (long)jtc.getAcceptors());
        Assert.assertEquals((String)"Wrong selector value for 16 cores", (long)3L, (long)jtc.getSelectors());
        Assert.assertEquals((String)"Wrong maxThreads value for 16 cores", (long)21L, (long)jtc.getMaxThreads());
        Assert.assertEquals((String)"Wrong minThreads value for 16 cores", (long)14L, (long)jtc.getMinThreads());
        Assert.assertEquals((String)"Wrong capacity value for 16 cores", (long)660000L, (long)jtc.getMaxCapacity());
        jtc = new JettyThreadCalculator(64);
        Assert.assertEquals((String)"Wrong acceptor value for 64 cores", (long)4L, (long)jtc.getAcceptors());
        Assert.assertEquals((String)"Wrong selector value for 64 cores", (long)8L, (long)jtc.getSelectors());
        Assert.assertEquals((String)"Wrong maxThreads value for 64 cores", (long)76L, (long)jtc.getMaxThreads());
        Assert.assertEquals((String)"Wrong minThreads value for 64 cores", (long)36L, (long)jtc.getMinThreads());
        Assert.assertEquals((String)"Wrong capacity value for 64 cores", (long)3120000L, (long)jtc.getMaxCapacity());
        jtc = new JettyThreadCalculator(44738);
        Assert.assertEquals((String)"Wrong acceptor value for max cores", (long)2982L, (long)jtc.getAcceptors());
        Assert.assertEquals((String)"Wrong selector value for max cores", (long)5965L, (long)jtc.getSelectors());
        Assert.assertEquals((String)"Wrong maxThreads value for max cores", (long)53685L, (long)jtc.getMaxThreads());
        Assert.assertEquals((String)"Wrong minThreads value for max cores", (long)26841L, (long)jtc.getMinThreads());
        Assert.assertEquals((String)"Wrong capacity value for max cores", (long)2147460000L, (long)jtc.getMaxCapacity());
    }

    @Test
    public void shouldNotAllowLessThanOneThread() {
        try {
            new JettyThreadCalculator(0);
            Assert.fail((String)"Should not succeed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Max threads can't be less than 1", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldNotAllowMoreThanMaxValue() {
        try {
            new JettyThreadCalculator(44739);
            Assert.fail((String)"Should not succeed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Max threads can't exceed %d", 44738), (Object)e.getMessage());
        }
    }
}

