/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import javax.servlet.http.HttpServletRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappedDatabase;
import org.neo4j.server.rest.management.console.CypherSession;
import org.neo4j.test.TestGraphDatabaseFactory;

public class CypherSessionTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReturnASingleNode() throws Throwable {
        GraphDatabaseFacade graphdb = (GraphDatabaseFacade)new TestGraphDatabaseFactory().newImpermanentDatabase();
        WrappedDatabase database = new WrappedDatabase(graphdb);
        CypherExecutor executor = new CypherExecutor((Database)database, (LogProvider)NullLogProvider.getInstance());
        executor.start();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"127.0.0.1");
        Mockito.when((Object)request.getRemotePort()).thenReturn((Object)5678);
        Mockito.when((Object)request.getServerName()).thenReturn((Object)"127.0.0.1");
        Mockito.when((Object)request.getServerPort()).thenReturn((Object)7474);
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)"/");
        try {
            CypherSession session = new CypherSession(executor, (LogProvider)NullLogProvider.getInstance(), request);
            Pair result = session.evaluate("create (a) return a");
            Assert.assertThat((Object)result.first(), (Matcher)CoreMatchers.containsString((String)"Node[0]"));
        }
        finally {
            graphdb.shutdown();
        }
    }
}

